/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequest
implements ChangeRequestChain {
    @NotNull
    private final List<DiffRequestPresentable> mySteps;
    private final boolean myShowFrame;
    private int myIndex;
    private final DiffExtendUIFactory myActionsFactory;
    private final AnAction myPrevChangeAction;
    private final AnAction myNextChangeAction;
    private final Project myProject;
    private final DiffChainContext myContext;
    private final AnAction mySelectChangeAction;

    public ChangeDiffRequest(Project project2, @NotNull List<DiffRequestPresentable> steps, DiffExtendUIFactory actionsFactory, boolean showFrame) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequest", "<init>"));
        }
        this.myProject = project2;
        this.mySteps = steps;
        this.myShowFrame = showFrame;
        this.myContext = new DiffChainContext();
        this.myIndex = 0;
        this.myActionsFactory = actionsFactory;
        this.myPrevChangeAction = ActionManager.getInstance().getAction("Diff.PrevChange");
        this.myNextChangeAction = ActionManager.getInstance().getAction("Diff.NextChange");
        this.mySelectChangeAction = ActionManager.getInstance().getAction("Diff.SelectedChange");
    }

    @NotNull
    public List<DiffRequestPresentable> getAllRequests() {
        List<DiffRequestPresentable> list = this.mySteps;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequest", "getAllRequests"));
        }
        return list;
    }

    private void onEveryMove(DiffRequest simpleRequest, boolean showFrame) {
        simpleRequest.passForDataContext(VcsDataKeys.DIFF_REQUEST_CHAIN, (Object)this);
        if (showFrame) {
            simpleRequest.addHint(DiffTool.HINT_SHOW_FRAME);
        } else {
            simpleRequest.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
        }
        if (this.mySteps.size() > 1) {
            simpleRequest.addHint(DiffTool.HINT_ALLOW_NO_DIFFERENCES);
        }
    }

    public void quickCheckHaveStuff() throws VcsException {
        if (this.mySteps.isEmpty()) {
            throw new VcsException("Nothing selected to show diff");
        }
        if (this.mySteps.size() == 1) {
            this.mySteps.get(0).haveStuff();
        }
    }

    @Nullable
    public DiffRequest init(int idx) {
        if (idx < 0 || idx > this.mySteps.size() - 1) {
            return null;
        }
        this.myIndex = idx - 1;
        DiffRequest result2 = this.moveForward();
        if (result2 == null && idx > 0) {
            this.myIndex = -1;
            return this.moveForward();
        }
        return result2;
    }

    public boolean canMoveForward() {
        return this.myIndex < this.mySteps.size() - 1;
    }

    public boolean canMoveBack() {
        return this.myIndex > 0;
    }

    @Nullable
    public DiffRequest moveForward() {
        return this.moveWithErrorReport(new MoveDirection(){

            @Override
            public boolean canMove() {
                return ChangeDiffRequest.this.canMoveForward();
            }

            @Override
            public int direction() {
                return 1;
            }
        });
    }

    @Nullable
    public DiffRequest moveTo(DiffRequestPresentable presentable) {
        int index = this.findRequest(presentable);
        if (index == -1) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        DiffRequestPresentable.MyResult result2 = this.moveImpl(presentable, errors);
        this.showErrors(errors);
        if (result2 == null) {
            return null;
        }
        if (DiffPresentationReturnValue.removeFromList.equals((Object)result2.getReturnValue())) {
            return null;
        }
        this.myIndex = index;
        return result2.getRequest();
    }

    @Nullable
    public DiffRequestPresentable getCurrentRequest() {
        if (this.myIndex < 0 || this.myIndex >= this.mySteps.size()) {
            return null;
        }
        return this.mySteps.get(this.myIndex);
    }

    private int findRequest(DiffRequestPresentable presentable) {
        for (int i = 0; i < this.mySteps.size(); ++i) {
            DiffRequestPresentable step = this.mySteps.get(i);
            if (!step.equals(presentable)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private DiffRequest moveWithErrorReport(MoveDirection moveDirection) {
        ArrayList<String> errors = new ArrayList<String>();
        DiffRequest diffRequest = this.moveInc(moveDirection, errors);
        this.showErrors(errors);
        return diffRequest;
    }

    @Nullable
    private DiffRequestPresentable.MyResult moveImpl(DiffRequestPresentable requestPresentable, List<String> errors) {
        DiffRequestPresentable.MyResult result2 = requestPresentable.step(this.myContext);
        DiffPresentationReturnValue returnValue = result2.getReturnValue();
        if (DiffPresentationReturnValue.quit.equals((Object)returnValue)) {
            errors.addAll(result2.getErrors());
            return null;
        }
        if (DiffPresentationReturnValue.removeFromList.equals((Object)returnValue)) {
            this.mySteps.remove(requestPresentable);
            errors.addAll(result2.getErrors());
            return result2;
        }
        DiffRequest request = result2.getRequest();
        this.takeStuffFromFactory(request, requestPresentable.createActions(this.myActionsFactory));
        this.onEveryMove(request, this.myShowFrame);
        return result2;
    }

    @Nullable
    private DiffRequest moveInc(MoveDirection moveDirection, List<String> errors) {
        while (moveDirection.canMove()) {
            int nextIdx = this.myIndex + moveDirection.direction();
            DiffRequestPresentable diffRequestPresentable = this.mySteps.get(nextIdx);
            DiffRequestPresentable.MyResult result2 = this.moveImpl(diffRequestPresentable, errors);
            if (result2 == null) {
                return null;
            }
            if (DiffPresentationReturnValue.removeFromList.equals((Object)result2.getReturnValue())) {
                if (moveDirection.direction() >= 0) continue;
                this.myIndex += moveDirection.direction();
                continue;
            }
            this.myIndex = nextIdx;
            return result2.getRequest();
        }
        return null;
    }

    private void showErrors(List<String> errors) {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Following problems have occurred:\n\n");
        for (String error : errors) {
            sb.append(error).append('\n');
        }
        Messages.showErrorDialog((Project)this.myProject, (String)sb.toString(), (String)"Show Diff");
    }

    @Nullable
    public DiffRequest moveBack() {
        return this.moveWithErrorReport(new MoveDirection(){

            @Override
            public boolean canMove() {
                return ChangeDiffRequest.this.canMoveBack();
            }

            @Override
            public int direction() {
                return -1;
            }
        });
    }

    private void takeStuffFromFactory(DiffRequest request, final List<? extends AnAction> actions) {
        if (this.mySteps.size() > 1 || this.myActionsFactory != null) {
            request.setToolbarAddons(new DiffRequest.ToolbarAddons(){

                public void customize(DiffToolbar toolbar) {
                    if (ChangeDiffRequest.this.mySteps.size() > 1) {
                        toolbar.addSeparator();
                    }
                    toolbar.addAction(ChangeDiffRequest.this.myPrevChangeAction);
                    toolbar.addAction(ChangeDiffRequest.this.myNextChangeAction);
                    toolbar.addAction(ChangeDiffRequest.this.mySelectChangeAction);
                    if (ChangeDiffRequest.this.myActionsFactory != null) {
                        toolbar.addSeparator();
                        for (AnAction action : actions) {
                            toolbar.addAction(action);
                        }
                    }
                }
            });
        }
        if (this.myActionsFactory != null) {
            request.setBottomComponentFactory((Factory)new NullableFactory<JComponent>(){

                public JComponent create() {
                    return ChangeDiffRequest.this.myActionsFactory.createBottomComponent();
                }
            });
        }
    }

    private static interface MoveDirection {
        public boolean canMove();

        public int direction();
    }
}

