/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserUnversionedFilesNode
extends ChangesBrowserNode {
    private final int myUnversionedSize;
    private final int myUnversionedDirsSize;
    private boolean myManyUnversioned;
    @NotNull
    private final Runnable myDialogShower;

    public ChangesBrowserUnversionedFilesNode(@NotNull Project project2, int unversionedSize, int unversionedDirsSize, boolean manyUnversioned) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserUnversionedFilesNode", "<init>"));
        }
        super(UNVERSIONED_FILES_TAG);
        this.myUnversionedSize = unversionedSize;
        this.myUnversionedDirsSize = unversionedDirsSize;
        this.myManyUnversioned = manyUnversioned;
        this.myDialogShower = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserUnversionedFilesNode", "lambda$new$0"));
            }
            new UnversionedViewDialog(project2).show();
        };
    }

    public int getUnversionedSize() {
        return this.myUnversionedSize;
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        super.render(renderer, selected, expanded, hasFocus);
        if (this.isManyUnversioned()) {
            renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append("browse", SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getCount() {
        return this.myUnversionedSize - this.myUnversionedDirsSize;
    }

    @Override
    public int getDirectoryCount() {
        return this.myUnversionedDirsSize;
    }

    public boolean isManyUnversioned() {
        return this.myManyUnversioned;
    }

    @Override
    public int getSortWeight() {
        return 8;
    }
}

