/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class IssueLinkConfigurationDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myIssueIDTextField;
    private JTextField myIssueLinkTextField;
    private JLabel myErrorLabel;
    private JTextField myExampleIssueIDTextField;
    private JTextField myExampleIssueLinkTextField;

    protected IssueLinkConfigurationDialog(Project project2) {
        super(project2, false);
        this.$$$setupUI$$$();
        this.init();
        this.myIssueIDTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                IssueLinkConfigurationDialog.this.updateFeedback();
            }
        });
        this.myExampleIssueIDTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                IssueLinkConfigurationDialog.this.updateFeedback();
            }
        });
    }

    private void updateFeedback() {
        this.myErrorLabel.setText(" ");
        try {
            Pattern p = Pattern.compile(this.myIssueIDTextField.getText());
            if (this.myIssueIDTextField.getText().length() > 0) {
                Matcher matcher = p.matcher(this.myExampleIssueIDTextField.getText());
                if (matcher.matches()) {
                    this.myExampleIssueLinkTextField.setText(matcher.replaceAll(this.myIssueLinkTextField.getText()));
                } else {
                    this.myExampleIssueLinkTextField.setText("<no match>");
                }
            }
        }
        catch (Exception ex) {
            this.myErrorLabel.setText("Invalid regular expression: " + ex.getMessage());
            this.myExampleIssueLinkTextField.setText("");
        }
        this.setOKActionEnabled(this.myErrorLabel.getText().equals(" "));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.settings.vcs.issue.navigation.add.link";
    }

    public IssueNavigationLink getLink() {
        return new IssueNavigationLink(this.myIssueIDTextField.getText(), this.myIssueLinkTextField.getText());
    }

    public void setLink(IssueNavigationLink link) {
        this.myIssueIDTextField.setText(link.getIssueRegexp());
        this.myIssueLinkTextField.setText(link.getLinkRegexp());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myIssueIDTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(Color.red);
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Example", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Issue ID:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Issue link:");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExampleIssueIDTextField = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myExampleIssueLinkTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Issue ID (regular expression):");
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Issue link (replacement expression):");
        jPanel3.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIssueIDTextField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        this.myIssueLinkTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

