/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CustomizeUIAction;
import com.intellij.ide.actions.ViewToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.laf.darcula.ui.DarculaRootPaneUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarCustomComponentFactory;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdePanePanel;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.MemoryUsagePanel;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeRootPane
extends JRootPane
implements UISettingsListener {
    private JComponent myToolbar;
    private IdeStatusBarImpl myStatusBar;
    private boolean myStatusBarDisposed;
    private final Box myNorthPanel = Box.createVerticalBox();
    private final List<IdeRootPaneNorthExtension> myNorthComponents = new ArrayList<IdeRootPaneNorthExtension>();
    private ToolWindowsPane myToolWindowsPane;
    private JBPanel myContentPane;
    private final ActionManager myActionManager;
    private final boolean myGlassPaneInitialized;
    private final IdeGlassPaneImpl myGlassPane;
    private final Application myApplication;
    private MemoryUsagePanel myMemoryWidget;
    private final StatusBarCustomComponentFactory[] myStatusBarCustomComponentFactories;
    private boolean myFullScreen;

    public IdeRootPane(ActionManagerEx actionManager, DataManager dataManager, Application application, final IdeFrame frame) {
        if (SystemInfo.isWindows && (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) && frame instanceof IdeFrameImpl) {
            this.setWindowDecorationStyle(1);
        }
        this.myActionManager = actionManager;
        this.myContentPane.add((Component)this.myNorthPanel, (Object)"North");
        this.myContentPane.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){});
        this.myStatusBarCustomComponentFactories = (StatusBarCustomComponentFactory[])application.getExtensions(StatusBarCustomComponentFactory.EP_NAME);
        this.myApplication = application;
        this.createStatusBar(frame);
        this.updateStatusBarVisibility();
        this.updateToolbar();
        this.myContentPane.add((Component)this.myStatusBar, (Object)"South");
        if (WindowManagerImpl.isFloatingMenuBarSupported()) {
            if (!this.isDecoratedMenu()) {
                this.menuBar = new IdeMenuBar(actionManager, dataManager);
                this.getLayeredPane().add((Component)this.menuBar, new Integer(JLayeredPane.DEFAULT_LAYER - 1));
                if (frame instanceof IdeFrameEx) {
                    this.addPropertyChangeListener("ide.frame.full.screen", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            IdeRootPane.this.myFullScreen = ((IdeFrameEx)frame).isInFullScreen();
                        }
                    });
                }
            }
        } else {
            this.setJMenuBar(new IdeMenuBar(actionManager, dataManager));
        }
        this.myGlassPane = new IdeGlassPaneImpl(this);
        this.setGlassPane(this.myGlassPane);
        this.myGlassPaneInitialized = true;
        this.myGlassPane.setVisible(false);
    }

    @Override
    protected LayoutManager createRootLayout() {
        return WindowManagerImpl.isFloatingMenuBarSupported() ? new MyRootLayout() : super.createRootLayout();
    }

    @Override
    public void setGlassPane(Component glass) {
        if (this.myGlassPaneInitialized) {
            throw new IllegalStateException("Setting of glass pane for IdeFrame is prohibited");
        }
        super.setGlassPane(glass);
    }

    @Override
    public final void addNotify() {
        super.addNotify();
    }

    @Override
    public final void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            if (!this.myStatusBarDisposed) {
                this.myStatusBarDisposed = true;
                Disposer.dispose((Disposable)this.myStatusBar);
            }
            this.removeToolbar();
        }
        super.removeNotify();
    }

    final void setToolWindowsPane(@Nullable ToolWindowsPane toolWindowsPane) {
        JComponent contentPane = (JComponent)this.getContentPane();
        if (this.myToolWindowsPane != null) {
            contentPane.remove((Component)((Object)this.myToolWindowsPane));
        }
        this.myToolWindowsPane = toolWindowsPane;
        if (this.myToolWindowsPane != null) {
            contentPane.add((Component)((Object)this.myToolWindowsPane), "Center");
        }
        contentPane.revalidate();
    }

    @Override
    protected JLayeredPane createLayeredPane() {
        JBLayeredPane p = new JBLayeredPane();
        p.setName(this.getName() + ".layeredPane");
        return p;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.getLayout() != null && UIUtil.isUnderAlloyLookAndFeel()) {
            return;
        }
        super.setLayout(mgr);
    }

    @Override
    protected final Container createContentPane() {
        this.myContentPane = new IdePanePanel(new BorderLayout());
        return this.myContentPane;
    }

    void updateToolbar() {
        this.removeToolbar();
        this.myToolbar = this.createToolbar();
        this.myNorthPanel.add((Component)this.myToolbar, 0);
        this.updateToolbarVisibility();
        this.myContentPane.revalidate();
    }

    private void removeToolbar() {
        if (this.myToolbar != null) {
            this.myNorthPanel.remove(this.myToolbar);
            this.myToolbar = null;
        }
    }

    void updateNorthComponents() {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            northComponent.revalidate();
        }
        this.myContentPane.revalidate();
    }

    void updateMainMenuActions() {
        ((IdeMenuBar)this.menuBar).updateMenuActions();
        this.menuBar.repaint();
    }

    private JComponent createToolbar() {
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainToolBar");
        ActionToolbar toolBar = this.myActionManager.createActionToolbar("MainToolbar", group, true);
        toolBar.setLayoutPolicy(1);
        DefaultActionGroup menuGroup = new DefaultActionGroup();
        menuGroup.add((AnAction)new ViewToolbarAction());
        menuGroup.add((AnAction)new CustomizeUIAction());
        PopupHandler.installUnknownPopupHandler((JComponent)toolBar.getComponent(), (ActionGroup)menuGroup, (ActionManager)this.myActionManager);
        return toolBar.getComponent();
    }

    private void createStatusBar(IdeFrame frame) {
        this.myStatusBar = new IdeStatusBarImpl();
        this.myStatusBar.install(frame);
        this.myMemoryWidget = new MemoryUsagePanel();
        if (this.myStatusBarCustomComponentFactories != null) {
            for (final StatusBarCustomComponentFactory componentFactory : this.myStatusBarCustomComponentFactories) {
                final JComponent c = componentFactory.createComponent((StatusBar)this.myStatusBar);
                this.myStatusBar.addWidget((StatusBarWidget)new CustomStatusBarWidget(){

                    public JComponent getComponent() {
                        return c;
                    }

                    @NotNull
                    public String ID() {
                        String string = c.getClass().getSimpleName();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeRootPane$3", "ID"));
                        }
                        return string;
                    }

                    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
                        if (type == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/IdeRootPane$3", "getPresentation"));
                        }
                        return null;
                    }

                    public void install(@NotNull StatusBar statusBar) {
                        if (statusBar == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/IdeRootPane$3", "install"));
                        }
                    }

                    public void dispose() {
                        componentFactory.disposeComponent((StatusBar)IdeRootPane.this.myStatusBar, c);
                    }
                }, "before Memory");
            }
        }
        this.myStatusBar.addWidget((StatusBarWidget)this.myMemoryWidget);
        this.myStatusBar.addWidget((StatusBarWidget)new IdeMessagePanel(frame, MessagePool.getInstance()), "before Memory");
        this.setMemoryIndicatorVisible(UISettings.getInstance().SHOW_MEMORY_INDICATOR);
    }

    void setMemoryIndicatorVisible(boolean visible) {
        if (this.myMemoryWidget != null) {
            this.myMemoryWidget.setShowing(visible);
            if (!SystemInfo.isMac) {
                this.myStatusBar.setBorder(BorderFactory.createEmptyBorder(1, 4, 0, visible ? 0 : 2));
            }
        }
    }

    @Nullable
    final StatusBar getStatusBar() {
        return this.myStatusBar;
    }

    public int getStatusBarHeight() {
        return this.myStatusBar.isVisible() ? this.myStatusBar.getHeight() : 0;
    }

    private void updateToolbarVisibility() {
        this.myToolbar.setVisible(UISettings.getInstance().SHOW_MAIN_TOOLBAR && !UISettings.getInstance().PRESENTATION_MODE);
    }

    private void updateStatusBarVisibility() {
        this.myStatusBar.setVisible(UISettings.getInstance().SHOW_STATUS_BAR && !UISettings.getInstance().PRESENTATION_MODE);
    }

    public void installNorthComponents(Project project2) {
        ContainerUtil.addAll(this.myNorthComponents, (Object[])Extensions.getExtensions((ExtensionPointName)IdeRootPaneNorthExtension.EP_NAME, (AreaInstance)project2));
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            this.myNorthPanel.add(northComponent.getComponent());
            northComponent.uiSettingsChanged(UISettings.getInstance());
        }
    }

    public void deinstallNorthComponents() {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            this.myNorthPanel.remove(northComponent.getComponent());
            Disposer.dispose((Disposable)northComponent);
        }
        this.myNorthComponents.clear();
    }

    public IdeRootPaneNorthExtension findByName(String name) {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            if (!Comparing.strEqual((String)name, (String)northComponent.getKey())) continue;
            return northComponent;
        }
        return null;
    }

    public void uiSettingsChanged(UISettings source) {
        BalloonLayout layout;
        this.setMemoryIndicatorVisible(source.SHOW_MEMORY_INDICATOR);
        this.updateToolbarVisibility();
        this.updateStatusBarVisibility();
        for (IdeRootPaneNorthExtension component : this.myNorthComponents) {
            component.uiSettingsChanged(source);
        }
        IdeFrame frame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)this);
        BalloonLayout balloonLayout = layout = frame != null ? frame.getBalloonLayout() : null;
        if (layout instanceof BalloonLayoutImpl) {
            ((BalloonLayoutImpl)layout).queueRelayout();
        }
    }

    public ToolWindowsPane getToolWindowsPane() {
        return this.myToolWindowsPane;
    }

    public static boolean isFrameDecorated() {
        return SystemInfo.isWindows && Registry.is((String)"ide.win.frame.decoration");
    }

    public boolean isDecoratedMenu() {
        return this.getUI() instanceof DarculaRootPaneUI && IdeRootPane.isFrameDecorated();
    }

    private class MyRootLayout
    extends JRootPane.RootLayout {
        private MyRootLayout() {
            super(IdeRootPane.this);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets i = IdeRootPane.this.getInsets();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getPreferredSize() : parent.getSize();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen && !IdeRootPane.this.isDecoratedMenu() ? IdeRootPane.this.menuBar.getPreferredSize() : JBUI.emptySize();
            return new Dimension(Math.max(rd.width, mbd.width) + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets i = IdeRootPane.this.getInsets();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getMinimumSize() : parent.getSize();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen ? IdeRootPane.this.menuBar.getMinimumSize() : JBUI.emptySize();
            return new Dimension(Math.max(rd.width, mbd.width) + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            Insets i = IdeRootPane.this.getInsets();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen ? IdeRootPane.this.menuBar.getMaximumSize() : JBUI.emptySize();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - mbd.height - 1);
            return new Dimension(Math.min(rd.width, mbd.width) + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets i = IdeRootPane.this.getInsets();
            int contentY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (IdeRootPane.this.layeredPane != null) {
                IdeRootPane.this.layeredPane.setBounds(i.left, i.top, w, h);
            }
            if (IdeRootPane.this.glassPane != null) {
                IdeRootPane.this.glassPane.setBounds(i.left, i.top, w, h);
            }
            if (IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible()) {
                Dimension mbd = IdeRootPane.this.menuBar.getPreferredSize();
                IdeRootPane.this.menuBar.setBounds(0, 0, w, mbd.height);
                if (!IdeRootPane.this.myFullScreen) {
                    contentY += mbd.height;
                }
            }
            if (IdeRootPane.this.contentPane != null) {
                IdeRootPane.this.contentPane.setBounds(0, contentY, w, h - contentY);
            }
        }
    }
}

