/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.Profile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilesComboBox
extends ComboBox<InspectionProfileImpl> {
    private static final String PROJECT_LEVEL_SEPARATOR_TEXT = "Project Level";
    private static final String GLOBAL_LEVEL_SEPARATOR_TEXT = "Global Level";
    private SortedComboBoxModel<InspectionProfileImpl> myComboModel = new SortedComboBoxModel(this::compare);
    private InspectionProfileImpl myFirstGlobalProfile;

    public ProfilesComboBox() {
        this.setModel((ComboBoxModel)this.myComboModel);
        this.setRenderer(new ListCellRenderer<Object>(){
            ListCellRendererWrapper<InspectionProfileImpl> baseRenderer = new ListCellRendererWrapper<InspectionProfileImpl>(){

                public void customize(JList list, InspectionProfileImpl value, int index, boolean selected, boolean hasFocus) {
                    if (index == -1) {
                        this.setIcon(ProfilesComboBox.this.isProjectLevel(value) ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                    }
                    this.setText(ProfilesComboBox.this.getProfileName(value));
                }
            };

            @Override
            public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
                InspectionProfileImpl value = (InspectionProfileImpl)o;
                TitledSeparator separator = null;
                if (index != -1) {
                    if (!value.isProjectLevel()) {
                        if (value == ProfilesComboBox.this.myFirstGlobalProfile) {
                            separator = new TitledSeparator(ProfilesComboBox.GLOBAL_LEVEL_SEPARATOR_TEXT);
                        }
                    } else if (value == ProfilesComboBox.this.myComboModel.get(0)) {
                        separator = new TitledSeparator(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT);
                    }
                }
                Component renderedComponent = this.baseRenderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
                if (separator == null) {
                    return renderedComponent;
                }
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)separator.getLabel());
                separator.getLabel().setIcon(separator.getText().equals(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT) ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                separator.setBackground(renderedComponent.getBackground());
                separator.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)0, (int)2));
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)separator, "North");
                p.add(renderedComponent, "Center");
                p.setBackground(renderedComponent.getBackground());
                return p;
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl profile = ProfilesComboBox.this.getSelectedProfile();
                if (profile != null) {
                    ProfilesComboBox.this.onProfileChosen(profile);
                }
            }
        });
    }

    protected abstract boolean isProjectLevel(InspectionProfileImpl var1);

    @NotNull
    protected abstract String getProfileName(InspectionProfileImpl var1);

    protected abstract void onProfileChosen(InspectionProfileImpl var1);

    public void selectProfile(InspectionProfileImpl inspectionProfile) {
        this.setSelectedItem(inspectionProfile);
    }

    public void reset(Collection<? extends Profile> profiles) {
        this.myComboModel.clear();
        for (Profile profile : profiles) {
            this.myComboModel.add((Object)((InspectionProfileImpl)profile));
        }
        this.findFirstGlobalProfile();
        this.setSelectedIndex(0);
    }

    void removeProfile(InspectionProfileImpl profile) {
        this.myComboModel.remove((Object)profile);
        if (!this.isProjectLevel(profile) && profile == this.myFirstGlobalProfile) {
            this.findFirstGlobalProfile();
        }
    }

    void addProfile(InspectionProfileImpl inspectionProfile) {
        this.myComboModel.add((Object)inspectionProfile);
        if (!this.isProjectLevel(inspectionProfile)) {
            this.findFirstGlobalProfile();
        }
    }

    InspectionProfileImpl getSelectedProfile() {
        return (InspectionProfileImpl)this.myComboModel.getSelectedItem();
    }

    @NotNull
    List<InspectionProfileImpl> getProfiles() {
        List list = this.myComboModel.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/ProfilesComboBox", "getProfiles"));
        }
        return list;
    }

    private int compare(@NotNull InspectionProfileImpl p1, @NotNull InspectionProfileImpl p2) {
        if (p1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p1", "com/intellij/profile/codeInspection/ui/header/ProfilesComboBox", "compare"));
        }
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p2", "com/intellij/profile/codeInspection/ui/header/ProfilesComboBox", "compare"));
        }
        boolean isProjectLevel1 = this.isProjectLevel(p1);
        boolean isProjectLevel2 = this.isProjectLevel(p2);
        int res = Comparing.compare((boolean)isProjectLevel2, (boolean)isProjectLevel1);
        if (res != 0) {
            return res;
        }
        String currentProfileName1 = this.getProfileName(p1);
        String currentProfileName2 = this.getProfileName(p2);
        return Comparing.compare((Comparable)((Object)currentProfileName1), (Comparable)((Object)currentProfileName2));
    }

    private void findFirstGlobalProfile() {
        this.myFirstGlobalProfile = null;
        for (InspectionProfileImpl profile : this.getProfiles()) {
            if (this.isProjectLevel(profile)) continue;
            this.myFirstGlobalProfile = profile;
            break;
        }
    }
}

