/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final WhiteSpaceFormattingStrategy myWhiteSpaceStrategy;
    @NotNull
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.FormattingDocumentModelImpl");
    private final CodeStyleSettings mySettings;

    public FormattingDocumentModelImpl(@NotNull Document document2, PsiFile file2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "<init>"));
        }
        this.myDocument = document2;
        this.myFile = file2;
        if (file2 != null) {
            Language language = file2.getLanguage();
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(language);
        } else {
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy();
        }
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)(file2 != null ? file2.getProject() : null));
    }

    public static FormattingDocumentModelImpl createOn(PsiFile file2) {
        Document document2 = FormattingDocumentModelImpl.getDocumentToBeUsedFor(file2);
        if (document2 != null) {
            FormattingDocumentModelImpl.checkDocument(file2, document2);
            return new FormattingDocumentModelImpl(document2, file2);
        }
        return new FormattingDocumentModelImpl(new DocumentImpl(file2.getViewProvider().getContents(), true), file2);
    }

    private static void checkDocument(PsiFile file2, Document document2) {
        if (file2.getTextLength() != document2.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file2, document2));
        }
    }

    @Nullable
    public static Document getDocumentToBeUsedFor(PsiFile file2) {
        Project project2 = file2.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document2 == null) {
            return null;
        }
        if (PsiDocumentManager.getInstance((Project)project2).isUncommited(document2)) {
            return null;
        }
        PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2)).getSynchronizer();
        if (synchronizer.isDocumentAffectedByTransactions(document2)) {
            return null;
        }
        return document2;
    }

    public int getLineNumber(int offset) {
        if (offset > this.myDocument.getTextLength()) {
            LOG.error(String.format("Invalid offset detected (%d). Document length: %d. Target file: %s", offset, this.myDocument.getTextLength(), this.myFile));
        }
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.myDocument.getTextLength()) {
            LOG.error(String.format("Please submit a ticket to the tracker and attach current source file to it!%nInvalid processing detected: given text range (%s) targets non-existing regions (the boundaries are [0; %d)). File's language: %s", textRange, this.myDocument.getTextLength(), this.myFile.getLanguage()));
        }
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    @NotNull
    public Document getDocument() {
        Document document2 = this.myDocument;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "getDocument"));
        }
        return document2;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
        WhiteSpaceFormattingStrategy localStrategy;
        Language injectedLanguage;
        PsiElement injectedElement;
        WhiteSpaceFormattingStrategy strategy = this.myWhiteSpaceStrategy;
        if (strategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset) {
            return true;
        }
        PsiElement psiElement = injectedElement = this.myFile != null ? InjectedLanguageUtil.findElementAtNoCommit(this.myFile, startOffset) : null;
        if (injectedElement != null && !(injectedLanguage = injectedElement.getLanguage()).equals(this.myFile.getLanguage()) && (localStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(injectedLanguage)) != null) {
            return localStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset;
        }
        return false;
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
        }
        if (!changedViaPsi) {
            CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, this.myDocument.getCharsSequence(), startOffset, endOffset, this.mySettings, nodeAfter);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        PsiElement element = this.myFile.findElementAt(startOffset);
        if (element == null) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, element, startOffset, endOffset, this.mySettings);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
        }
        return charSequence;
    }

    public static boolean canUseDocumentModel(@NotNull Document document2, @NotNull PsiFile file2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "canUseDocumentModel"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "canUseDocumentModel"));
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
        return !psiDocumentManager.isUncommited(document2) && !psiDocumentManager.isDocumentBlockedByPsi(document2) && file2.getText().equals(document2.getText());
    }
}

