/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRegExpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    @Override
    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        switch (flag) {
            case 'd': 
            case 'i': 
            case 'm': 
            case 's': 
            case 'u': 
            case 'x': {
                return true;
            }
            case 'U': {
                return JavaRegExpHost.hasAtLeastJdkVersion(context, JavaSdkVersion.JDK_1_7);
            }
        }
        return false;
    }

    @Override
    public boolean characterNeedsEscaping(char c) {
        return c == ']' || c == '}';
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.isNamedGroup() && JavaRegExpHost.hasAtLeastJdkVersion(group, JavaSdkVersion.JDK_1_7);
    }

    @Override
    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isNamedGroupRef() && JavaRegExpHost.hasAtLeastJdkVersion(ref, JavaSdkVersion.JDK_1_7);
    }

    @Override
    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return JavaRegExpHost.hasAtLeastJdkVersion(regExpChar, JavaSdkVersion.JDK_1_7);
    }

    @Override
    public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        switch (simpleClass.getKind()) {
            case UNICODE_LINEBREAK: 
            case HORIZONTAL_SPACE: 
            case NON_HORIZONTAL_SPACE: 
            case NON_VERTICAL_SPACE: {
                return JavaRegExpHost.hasAtLeastJdkVersion(simpleClass, JavaSdkVersion.JDK_1_8);
            }
            case VERTICAL_SPACE: {
                return true;
            }
            case UNICODE_GRAPHEME: 
            case XML_NAME_START: 
            case NON_XML_NAME_START: 
            case XML_NAME_PART: 
            case NON_XML_NAME_PART: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return false;
    }

    private static boolean hasAtLeastJdkVersion(PsiElement element, JavaSdkVersion version) {
        return JavaRegExpHost.getJavaVersion(element).isAtLeast(version);
    }

    @NotNull
    private static JavaSdkVersion getJavaVersion(PsiElement element) {
        JavaSdkVersion version;
        Sdk sdk;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module2 != null && (sdk = ModuleRootManager.getInstance((Module)module2).getSdk()) != null && sdk.getSdkType() instanceof JavaSdk && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getJavaVersion"));
            }
            return javaSdkVersion;
        }
        JavaSdkVersion javaSdkVersion = JavaSdkVersion.JDK_1_9;
        if (javaSdkVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getJavaVersion"));
        }
        return javaSdkVersion;
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidCategory"));
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @Override
    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @Override
    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

