/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiDiamondTypeUtil.class.getName()));

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression, (PsiElement)context);
            if (inferenceResult.getErrorMessage() == null) {
                List types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    PsiMethod method = expression.resolveMethod();
                    PsiElement resolve2 = classReference.resolve();
                    if (resolve2 instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters = ((PsiClass)resolve2).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, (PsiCallExpression)expression, true, method, typeParameters);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                return psiElement;
            }
            PsiNewExpression expression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return psiElement.replace((PsiElement)parameterList);
        }
        return psiElement;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return parent;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent;
        StringBuilder text = new StringBuilder();
        text.append(javaCodeReferenceElement.getQualifiedName());
        text.append('<');
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result2 = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, (PsiElement)newExpression);
        text.append(StringUtil.join((Collection)result2.getInferredTypes(), (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getCanonicalText();
            }
        }, (String)","));
        text.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text.toString(), element);
        return CodeStyleManager.getInstance((Project)javaCodeReferenceElement.getProject()).reformat(javaCodeReferenceElement.replace((PsiElement)newReference));
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes((PsiElement)parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type, PsiElement context) {
        int idx;
        String typeText = type.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments, PsiCallExpression expression, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters) {
        try {
            PsiElement copy;
            PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression);
            if (typeByParent != null) {
                String arrayInitializer = "new " + typeByParent.getCanonicalText() + "[]{0}";
                PsiNewExpression newExpr = (PsiNewExpression)JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createExpressionFromText(arrayInitializer, (PsiElement)expression);
                PsiArrayInitializerExpression initializer = newExpr.getArrayInitializer();
                LOG.assertTrue(initializer != null);
                copy = initializer.getInitializers()[0].replace((PsiElement)expression);
            } else {
                PsiExpressionList argumentList = expression.getArgumentList();
                int offset = (argumentList != null ? argumentList : expression).getTextRange().getStartOffset();
                PsiCall call = LambdaUtil.treeWalkUp((PsiElement)expression);
                if (call != null) {
                    PsiCall callCopy = LambdaUtil.copyTopLevelCall((PsiCall)call);
                    copy = callCopy != null ? callCopy.findElementAt(offset - call.getTextRange().getStartOffset()) : null;
                } else {
                    PsiFile containingFile = expression.getContainingFile();
                    PsiFile fileCopy = (PsiFile)containingFile.copy();
                    copy = fileCopy.findElementAt(offset);
                    if (method != null && method.getContainingFile() == containingFile) {
                        PsiElement startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset());
                        LOG.assertTrue((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startMethodElementInCopy, PsiMethod.class)) != null, (Object)startMethodElementInCopy);
                    }
                }
            }
            PsiCallExpression exprCopy = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)copy, PsiCallExpression.class, (boolean)false);
            if (exprCopy != null) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)exprCopy.getProject()).getElementFactory();
                if (constructorRef) {
                    if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, (PsiNewExpression)exprCopy)) {
                        return false;
                    }
                } else {
                    LOG.assertTrue(method != null);
                    if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, exprCopy, method, typeParameters)) {
                        return false;
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.info((Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters) throws IncorrectOperationException {
        PsiReferenceParameterList list = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace((PsiElement)list);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (method != copyResult.getElement()) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            PsiType inferredType = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType((PsiType)inferredType) == null) continue;
            return false;
        }
        return true;
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference != null);
        PsiReferenceParameterList parameterList = classReference.getParameterList();
        LOG.assertTrue(parameterList != null);
        parameterList.replace((PsiElement)diamondParameterList);
        PsiType[] inferredArgs = classReference.getParameterList().getTypeArguments();
        if (typeArguments.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return true;
    }
}

