/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    public ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "<init>"));
        }
        this.myManager = manager;
    }

    public boolean processConstructorReferences(@NotNull Processor<PsiReference> processor2, final @NotNull PsiMethod constructor, final @NotNull PsiClass containingClass, @NotNull SearchScope searchScope, @NotNull Project project2, boolean ignoreAccessScope, boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        final boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        final boolean[] isEnum = new boolean[1];
        final boolean[] isUnder18 = new boolean[1];
        MethodUsagesSearcher.resolveInReadAction(project2, new Computable<Void>(){

            public Void compute() {
                constructorCanBeCalledImplicitly[0] = constructor.getParameterList().getParametersCount() == 0;
                isEnum[0] = containingClass.isEnum();
                isUnder18[0] = PsiUtil.getLanguageLevel((PsiElement)containingClass).isAtLeast(LanguageLevel.JDK_1_8);
                return null;
            }
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor2, constructor, project2, containingClass)) {
            return false;
        }
        PairProcessor processor1 = (reference, collector1) -> {
            PsiMethod constructor1;
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : this.myManager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)constructor1.getContainingClass()))) {
                return processor2.process(reference);
            }
            return true;
        };
        ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)searchScope, (boolean)ignoreAccessScope, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor2, constructor, project2, containingClass, searchScope)) {
            return false;
        }
        if (!((Boolean)MethodUsagesSearcher.resolveInReadAction(project2, () -> {
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            return this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project2, isStrictSignatureSearch, "this", processor2);
        })).booleanValue()) {
            return false;
        }
        Processor processor22 = inheritor -> {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$2"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$2"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$2"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$2"));
            }
            PsiElement navigationElement = inheritor.getNavigationElement();
            if (navigationElement instanceof PsiClass) {
                return this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, project2, isStrictSignatureSearch, "super", processor2);
            }
            return true;
        };
        return ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)searchScope, (boolean)false).forEach(processor22);
    }

    private static boolean processEnumReferences(@NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass aClass) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        return (Boolean)MethodUsagesSearcher.resolveInReadAction(project2, () -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processEnumReferences$3"));
            }
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processEnumReferences$3"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processEnumReferences$3"));
            }
            for (PsiField field : aClass.getFields()) {
                PsiReference reference;
                if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor2.process((Object)reference)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean process18MethodPointers(@NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass aClass, SearchScope searchScope) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        return ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(reference -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$5"));
            }
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$5"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$5"));
            }
            PsiElement element = reference.getElement();
            if (element != null) {
                return (Boolean)MethodUsagesSearcher.resolveInReadAction(project2, () -> {
                    if (constructor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$null$4"));
                    }
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$null$4"));
                    }
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() instanceof PsiKeyword && ((PsiMethodReferenceExpression)parent).isReferenceTo((PsiElement)constructor) && !processor2.process((Object)((PsiReference)parent))) {
                        return false;
                    }
                    return true;
                });
            }
            return true;
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project2, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull Processor<PsiReference> processor2) {
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (superOrThisKeyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superOrThisKeyword", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        PsiMethod[] constructors = inheritor.getConstructors();
        if (constructors.length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall((PsiMember)inheritor, processor2, constructor, project2, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement2;
            PsiCodeBlock body = method.getBody();
            if (body == null || method == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 0 && (statement2 = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression())) && refExpr.textMatches((CharSequence)superOrThisKeyword)) {
                boolean match;
                PsiElement referencedElement = refExpr.resolve();
                if (!(referencedElement instanceof PsiMethod)) continue;
                PsiMethod constructor1 = (PsiMethod)referencedElement;
                boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass());
                if (!match || processor2.process((Object)refExpr)) continue;
                return false;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)method) || this.processImplicitConstructorCall((PsiMember)method, processor2, constructor, project2, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass containingClass) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        boolean same = (Boolean)MethodUsagesSearcher.resolveInReadAction(project2, () -> {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processImplicitConstructorCall$6"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processImplicitConstructorCall$6"));
            }
            return this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)containingClass.getSuperClass());
        });
        if (!same) {
            return true;
        }
        return processor2.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            public PsiElement getElement() {
                return usage;
            }

            @Override
            public TextRange getRangeInElement() {
                int startOffsetInParent;
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)usage).getNameIdentifier()) != null && (startOffsetInParent = identifier.getStartOffsetInParent()) >= 0) {
                    return TextRange.from((int)startOffsetInParent, (int)identifier.getTextLength());
                }
                return super.getRangeInElement();
            }
        });
    }
}

