/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFunctionalExpressionSearcher.class.getName()));
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        boolean isVoid;
        int expectedFunExprParamsCount;
        GlobalSearchScope useScope;
        Project project2;
        PsiClass aClass;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        AccessToken token = ReadAction.start();
        try {
            aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !LambdaUtil.isFunctionalClass((PsiClass)aClass)) {
                return;
            }
            project2 = aClass.getProject();
            Set<Module> highLevelModules = JavaFunctionalExpressionSearcher.getJava8Modules(project2);
            if (highLevelModules.isEmpty()) {
                return;
            }
            useScope = JavaFunctionalExpressionSearcher.convertToGlobalScope(project2, queryParameters.getEffectiveSearchScope());
            PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
            LOG.assertTrue(functionalInterfaceMethod != null);
            expectedFunExprParamsCount = functionalInterfaceMethod.getParameterList().getParameters().length;
            isVoid = PsiType.VOID.equals((Object)functionalInterfaceMethod.getReturnType());
        }
        finally {
            token.finish();
        }
        Set<VirtualFile> candidateFiles = JavaFunctionalExpressionSearcher.getFilesWithFunctionalExpressionsScope(project2, (GlobalSearchScope)new JavaSourceFilterScope(useScope));
        if (candidateFiles.size() < 5) {
            JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, candidateFiles, expectedFunExprParamsCount, isVoid);
            return;
        }
        GlobalSearchScope candidateScope = GlobalSearchScope.filesScope((Project)project2, candidateFiles);
        Collection<PsiMethod> methodCandidates = JavaFunctionalExpressionSearcher.getCandidateMethodsWithSuitableParams(aClass, project2, useScope, candidateFiles, candidateScope);
        LinkedHashSet<VirtualFile> filesToProcess = new LinkedHashSet<VirtualFile>();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        for (PsiMethod psiMethod : methodCandidates) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!psiMethod.isValid()) {
                    return;
                }
                int parametersCount = psiMethod.getParameterList().getParametersCount();
                boolean varArgs = psiMethod.isVarArgs();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                GlobalSearchScope methodUseScope = JavaFunctionalExpressionSearcher.convertToGlobalScope(project2, psiMethod.getUseScope());
                LinkedHashMap<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> holders = new LinkedHashMap<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>>();
                SuitableFilesProcessor processor2 = new SuitableFilesProcessor(holders, expectedFunExprParamsCount, parametersCount, varArgs, parameters);
                fileBasedIndex.processValues(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, (Object)psiMethod.getName(), null, (FileBasedIndex.ValueProcessor)processor2, useScope.intersectWith(methodUseScope));
                block0: for (Map.Entry<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> entry : holders.entrySet()) {
                    for (JavaFunctionalExpressionIndex.IndexHolder holder : entry.getValue()) {
                        if (!processor2.canBeFunctional(holder)) continue;
                        filesToProcess.add(entry.getKey());
                        continue block0;
                    }
                }
            });
        }
        JavaFunctionalExpressionSearcher.collectFilesWithTypeOccurrencesAndFieldAssignments(aClass, candidateScope, filesToProcess);
        JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, filesToProcess, expectedFunExprParamsCount, isVoid);
    }

    @NotNull
    private static Set<Module> getJava8Modules(Project project2) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project2).isAtLeast(LanguageLevel.JDK_1_8);
        com.intellij.util.containers.HashSet highLevelModules = new com.intellij.util.containers.HashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module2).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            highLevelModules.add(module2);
        }
        com.intellij.util.containers.HashSet hashSet = highLevelModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getJava8Modules"));
        }
        return hashSet;
    }

    private static void searchInFiles(final PsiClass aClass, final Processor<PsiFunctionalExpression> consumer, Set<VirtualFile> filesToProcess, final int expectedFunExprParamsCount, final boolean isVoid) {
        LOG.info("#usage files: " + filesToProcess.size());
        ContainerUtil.process(filesToProcess, (Processor)new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile file2) {
                return JavaFunctionalExpressionSearcher.processFileWithFunctionalInterfaces(aClass, expectedFunExprParamsCount, isVoid, (Processor<PsiFunctionalExpression>)consumer, file2);
            }
        });
    }

    private static Collection<PsiMethod> getCandidateMethodsWithSuitableParams(final PsiClass aClass, final Project project2, final GlobalSearchScope useScope, final Set<VirtualFile> candidateFiles, final GlobalSearchScope candidateScope) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiMethod>>(){

            public Collection<PsiMethod> compute() {
                if (!aClass.isValid()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope visibleFromCandidates = JavaFunctionalExpressionSearcher.combineResolveScopes(project2, candidateFiles);
                HashSet usedMethodNames = ContainerUtilRt.newHashSet();
                FileBasedIndex.getInstance().processAllKeys(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, Processors.cancelableCollectProcessor((Collection)usedMethodNames), candidateScope, null);
                LinkedHashSet methods = ContainerUtil.newLinkedHashSet();
                Processor methodProcessor = method -> {
                    if (usedMethodNames.contains(method.getName())) {
                        methods.add(method);
                    }
                    return true;
                };
                StubIndexKey<String, PsiMethod> key2 = JavaMethodParameterTypesIndex.getInstance().getKey();
                StubIndex index = StubIndex.getInstance();
                index.processElements(key2, (Object)aClass.getName(), project2, useScope.intersectWith(visibleFromCandidates), PsiMethod.class, methodProcessor);
                index.processElements(key2, (Object)"$TYPE_PARAMETER$", project2, visibleFromCandidates, PsiMethod.class, methodProcessor);
                LOG.info("#methods: " + methods.size());
                return methods;
            }
        });
    }

    @NotNull
    private static GlobalSearchScope combineResolveScopes(Project project2, Set<VirtualFile> candidateFiles) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        LinkedHashSet resolveScopes = ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.mapNotNull(candidateFiles, file2 -> {
            PsiFile psiFile = file2.isValid() ? psiManager.findFile(file2) : null;
            return psiFile == null ? null : psiFile.getResolveScope();
        }));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])resolveScopes.toArray(new GlobalSearchScope[resolveScopes.size()]));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "combineResolveScopes"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static Set<VirtualFile> getFilesWithFunctionalExpressionsScope(Project project2, GlobalSearchScope useScope) {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project2);
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)files);
        helper.processFilesWithText(useScope, (short)1, true, "::", (Processor<VirtualFile>)processor2);
        helper.processFilesWithText(useScope, (short)1, true, "->", (Processor<VirtualFile>)processor2);
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getFilesWithFunctionalExpressionsScope"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static GlobalSearchScope convertToGlobalScope(Project project2, SearchScope useScope) {
        GlobalSearchScope scope;
        if (useScope instanceof GlobalSearchScope) {
            scope = (GlobalSearchScope)useScope;
        } else if (useScope instanceof LocalSearchScope) {
            com.intellij.util.containers.HashSet files = new com.intellij.util.containers.HashSet();
            ContainerUtil.addAllNotNull((Collection)files, (Iterable)ContainerUtil.map((Object[])((LocalSearchScope)useScope).getScope(), element -> PsiUtilCore.getVirtualFile((PsiElement)element)));
            scope = GlobalSearchScope.filesScope((Project)project2, (Collection)files);
        } else {
            scope = new EverythingGlobalScope(project2);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "convertToGlobalScope"));
        }
        return globalSearchScope;
    }

    private static void collectFilesWithTypeOccurrencesAndFieldAssignments(PsiClass aClass, GlobalSearchScope filesScope, final LinkedHashSet<VirtualFile> usageFiles) {
        LinkedHashSet fields = new LinkedHashSet();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)filesScope)) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement element = reference.getElement();
                if (element != null) {
                    PsiElement gParent;
                    ContainerUtil.addIfNotNull((Collection)usageFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)element));
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiTypeElement && (gParent = parent.getParent()) instanceof PsiField && !((PsiField)gParent).hasModifierProperty("private") && !((PsiField)gParent).hasModifierProperty("final")) {
                        fields.add((PsiField)gParent);
                    }
                }
            });
        }
        for (PsiField field : fields) {
            ReferencesSearch.search((PsiElement)field, (SearchScope)filesScope).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference fieldRef) {
                    PsiElement fieldElement = fieldRef.getElement();
                    PsiAssignmentExpression varElementParent = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)fieldElement, PsiAssignmentExpression.class);
                    if (varElementParent != null && PsiTreeUtil.isAncestor((PsiElement)varElementParent.getLExpression(), (PsiElement)fieldElement, (boolean)false)) {
                        ContainerUtil.addIfNotNull((Collection)usageFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)fieldElement));
                    }
                    return true;
                }
            });
        }
    }

    private static boolean processFileWithFunctionalInterfaces(final PsiClass aClass, final int expectedParamCount, final boolean isVoid, final Processor<PsiFunctionalExpression> consumer, VirtualFile file2) {
        PsiFile psiFile = aClass.getManager().findFile(file2);
        if (psiFile != null) {
            final Ref ref = new Ref((Object)true);
            psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private void visitFunctionalExpression(PsiFunctionalExpression expression) {
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)PsiUtil.resolveClassInType((PsiType)functionalInterfaceType), (PsiClass)aClass, (boolean)true) && !consumer.process((Object)expression)) {
                        ref.set((Object)false);
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    if (expression.getParameterList().getParametersCount() == expectedParamCount) {
                        PsiElement body;
                        if (isVoid && (body = expression.getBody()) instanceof PsiCodeBlock) {
                            PsiReturnStatement[] statements;
                            for (PsiReturnStatement statement2 : statements = PsiUtil.findReturnStatements((PsiCodeBlock)((PsiCodeBlock)body))) {
                                if (statement2.getReturnValue() == null) continue;
                                return;
                            }
                        }
                        this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                    }
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    super.visitMethodReferenceExpression(expression);
                    this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                }
            });
            if (!((Boolean)ref.get()).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private static class SuitableFilesProcessor
    implements FileBasedIndex.ValueProcessor<Collection<JavaFunctionalExpressionIndex.IndexHolder>> {
        private final Map<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> myHolders;
        private final int myExpectedFunExprParamsCount;
        private final int myParametersCount;
        private final boolean myVarArgs;
        private final PsiParameter[] myParameters;

        public SuitableFilesProcessor(Map<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> holders, int expectedFunExprParamsCount, int parametersCount, boolean varArgs, PsiParameter[] parameters) {
            this.myHolders = holders;
            this.myExpectedFunExprParamsCount = expectedFunExprParamsCount;
            this.myParametersCount = parametersCount;
            this.myVarArgs = varArgs;
            this.myParameters = parameters;
        }

        public boolean process(VirtualFile file2, Collection<JavaFunctionalExpressionIndex.IndexHolder> holders) {
            Set<JavaFunctionalExpressionIndex.IndexHolder> savedHolders = this.myHolders.get(file2);
            for (JavaFunctionalExpressionIndex.IndexHolder holder : holders) {
                boolean suitableParamNumbers;
                int lambdaParamsNumber = holder.getLambdaParamsNumber();
                if (lambdaParamsNumber != this.myExpectedFunExprParamsCount && lambdaParamsNumber != -1) continue;
                if (this.myVarArgs) {
                    suitableParamNumbers = holder.getMethodArgsLength() >= this.myParametersCount - 1;
                } else {
                    boolean bl = suitableParamNumbers = holder.getMethodArgsLength() == this.myParametersCount;
                }
                if (!suitableParamNumbers) continue;
                if (savedHolders == null) {
                    savedHolders = new LinkedHashSet<JavaFunctionalExpressionIndex.IndexHolder>();
                    this.myHolders.put(file2, savedHolders);
                }
                savedHolders.add(holder);
                break;
            }
            return true;
        }

        private boolean canBeFunctional(JavaFunctionalExpressionIndex.IndexHolder holder) {
            PsiClass functionalCandidate;
            int paramIdx = holder.getFunctionExpressionIndex();
            PsiType paramType = this.myParameters[paramIdx >= this.myParametersCount ? this.myParametersCount - 1 : paramIdx].getType();
            if (paramType instanceof PsiEllipsisType) {
                paramType = ((PsiEllipsisType)paramType).getComponentType();
            }
            return (functionalCandidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType)) instanceof PsiTypeParameter || LambdaUtil.isFunctionalClass((PsiClass)functionalCandidate);
        }
    }
}

