/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PushDownDelegate<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement> {
    public static final LanguageExtension<PushDownDelegate> EP_NAME = new LanguageExtension("com.intellij.refactoring.pushDown");

    @Nullable
    protected static <MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement> PushDownDelegate<MemberInfo, Member> findDelegate(@NotNull PsiElement sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/refactoring/memberPushDown/PushDownDelegate", "findDelegate"));
        }
        return (PushDownDelegate)EP_NAME.forLanguage(sourceClass.getLanguage());
    }

    @Nullable
    protected static PushDownDelegate findDelegateForTarget(@NotNull PsiElement sourceClass, @NotNull PsiElement targetClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/refactoring/memberPushDown/PushDownDelegate", "findDelegateForTarget"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/memberPushDown/PushDownDelegate", "findDelegateForTarget"));
        }
        for (PushDownDelegate delegate : EP_NAME.allForLanguage(targetClass.getLanguage())) {
            if (!delegate.isApplicableForSource(sourceClass)) continue;
            return delegate;
        }
        return null;
    }

    protected abstract boolean isApplicableForSource(@NotNull PsiElement var1);

    protected abstract List<PsiElement> findInheritors(PushDownData<MemberInfo, Member> var1);

    protected UsageInfo createUsageInfo(PsiElement element) {
        return new UsageInfo(element);
    }

    protected abstract void checkSourceClassConflicts(PushDownData<MemberInfo, Member> var1, MultiMap<PsiElement, String> var2);

    protected abstract void checkTargetClassConflicts(@Nullable PsiElement var1, PushDownData<MemberInfo, Member> var2, MultiMap<PsiElement, String> var3, @Nullable NewSubClassData var4);

    protected void prepareToPush(PushDownData<MemberInfo, Member> pushDownData) {
    }

    protected abstract void pushDownToClass(PsiElement var1, PushDownData<MemberInfo, Member> var2);

    protected abstract void removeFromSourceClass(PushDownData<MemberInfo, Member> var1);

    protected NewSubClassData preprocessNoInheritorsFound(PsiElement sourceClass, String conflictDialogTitle) {
        String message = RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)sourceClass)}) + "\n" + RefactoringBundle.message((String)"push.down.will.delete.members");
        int answer = Messages.showYesNoDialog((String)message, (String)conflictDialogTitle, (Icon)Messages.getWarningIcon());
        if (answer != 0) {
            return NewSubClassData.ABORT_REFACTORING;
        }
        return null;
    }

    @Nullable
    protected PsiElement createSubClass(PsiElement aClass, NewSubClassData subClassData) {
        return null;
    }
}

