/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeSignatureHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeTypeSignatureHandler.class.getName()));
    public static final String REFACTORING_NAME = "Type Migration";

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement element = file2.findElementAt(offset);
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent = typeElement.getParent();
            PsiElement[] toMigrate = null;
            if (parent instanceof PsiVariable) {
                toMigrate = ChangeTypeSignatureHandler.extractReferencedVariables(typeElement);
            } else if (parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
                toMigrate = new PsiElement[]{parent};
            }
            if (toMigrate != null && toMigrate.length > 0) {
                ChangeTypeSignatureHandler.invoke(project2, toMigrate, null, null, editor);
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"The caret should be positioned on type of field, variable, method or method parameter to be refactored", (String)REFACTORING_NAME, (String)"refactoring.migrateType");
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project2, element);
    }

    public static boolean invokeOnElement(Project project2, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile || ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project2, new PsiElement[]{element}, null, null, null);
            return true;
        }
        return false;
    }

    protected static boolean isClassArgument(PsiElement element) {
        if (element instanceof PsiReferenceParameterList) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == element;
            }
            if (member instanceof PsiClass) {
                PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
                PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
                return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
            }
        }
        return false;
    }

    public static void invoke(Project project2, PsiElement[] roots, PsiType type, TypeMigrationRules rules, Editor editor) {
        if (Util.canBeMigrated(roots)) {
            TypeMigrationDialog.SingleElement dialog = new TypeMigrationDialog.SingleElement(project2, roots, type, rules);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered"), (String)RefactoringBundle.message((String)"unable.to.start.type.migration"), null);
    }

    @NotNull
    private static PsiElement[] extractReferencedVariables(PsiTypeElement typeElement) {
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiDeclarationStatement.class);
        if (declaration == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "extractReferencedVariables"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = (PsiElement[])Arrays.stream(declaration.getDeclaredElements()).filter(PsiVariable.class::isInstance).filter(e -> ((PsiVariable)e).getTypeElement() == typeElement).toArray(PsiElement[]::new);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "extractReferencedVariables"));
        }
        return psiElementArray;
    }
}

