/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FluentIterableConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaOptionalConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.hash.HashMap;
import com.siyeh.ig.controlflow.DoubleNegationInspection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFluentIterableConversionRule
extends BaseGuavaTypeConversionRule {
    private static final Logger LOG = Logger.getInstance(GuavaFluentIterableConversionRule.class);
    private static final Map<String, TypeConversionDescriptorFactory> DESCRIPTORS_MAP = new HashMap();
    public static final Set<String> CHAIN_HEAD_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"from", "of"});
    public static final String FLUENT_ITERABLE = "com.google.common.collect.FluentIterable";
    public static final String STREAM_COLLECT_TO_LIST = "$it$.collect(java.util.stream.Collectors.toList())";

    @Override
    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return super.isValidMethodQualifierToConvert(aClass) || aClass != null && "com.google.common.base.Optional".equals(aClass.getQualifiedName());
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(@NotNull PsiType from, @NotNull PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "findConversionForMethod"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "findConversionForMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "findConversionForMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "findConversionForMethod"));
        }
        if (context instanceof PsiMethodCallExpression) {
            return GuavaFluentIterableConversionRule.buildCompoundDescriptor((PsiMethodCallExpression)context, to, labeler);
        }
        return GuavaFluentIterableConversionRule.getOneMethodDescriptor(methodName, method, from, to, context);
    }

    @Nullable
    private static TypeConversionDescriptorBase getOneMethodDescriptor(@NotNull String methodName, @NotNull PsiMethod method, @NotNull PsiType from, @Nullable PsiType to, @Nullable PsiExpression context) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "getOneMethodDescriptor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "getOneMethodDescriptor"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "getOneMethodDescriptor"));
        }
        TypeConversionDescriptor descriptorBase = null;
        PsiType conversionType = null;
        boolean needSpecifyType = true;
        if (methodName.equals("of")) {
            descriptorBase = new TypeConversionDescriptor("'FluentIterable*.of($arr$)", "java.util.Arrays.stream($arr$)");
        } else if (methodName.equals("from")) {
            descriptorBase = new TypeConversionDescriptor("'FluentIterable*.from($it$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
                    PsiExpression argument = PseudoLambdaReplaceTemplate.replaceTypeParameters(methodCall.getArgumentList().getExpressions()[0]);
                    if (argument == null) {
                        return expression;
                    }
                    boolean isCollection = InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)argument.getType()), (String)"java.util.Collection");
                    this.setReplaceByString(isCollection ? "$it$.stream()" : "java.util.stream.StreamSupport.stream($it$.spliterator(), false)");
                    return super.replace(expression, evaluator);
                }
            };
        } else if (methodName.equals("filter")) {
            descriptorBase = FluentIterableConversionUtil.getFilterDescriptor(method);
        } else if (methodName.equals("isEmpty")) {
            descriptorBase = new TypeConversionDescriptor("$q$.isEmpty()", null){

                @Override
                public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
                    PsiElement parent = expression.getParent();
                    boolean isDoubleNegation = false;
                    if (parent instanceof PsiExpression && DoubleNegationInspection.isNegation((PsiExpression)parent)) {
                        isDoubleNegation = true;
                        expression = (PsiExpression)parent.replace((PsiElement)expression);
                    }
                    this.setReplaceByString((isDoubleNegation ? "" : "!") + "$q$.findAny().isPresent()");
                    return super.replace(expression, evaluator);
                }
            };
            needSpecifyType = false;
        } else if (methodName.equals("transformAndConcat")) {
            descriptorBase = new FluentIterableConversionUtil.TransformAndConcatConversionRule();
        } else if (methodName.equals("toArray")) {
            descriptorBase = FluentIterableConversionUtil.getToArrayDescriptor(from, context);
            needSpecifyType = false;
        } else if (methodName.equals("copyInto")) {
            descriptorBase = new FluentIterableConversionUtil.CopyIntoConversionDescriptor();
            needSpecifyType = false;
        } else if (methodName.equals("append")) {
            descriptorBase = GuavaFluentIterableConversionRule.createDescriptorForAppend(method, context);
        } else if (methodName.equals("get")) {
            descriptorBase = new TypeConversionDescriptor("$it$.get($p$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
                    Object value;
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
                    PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
                    this.setReplaceByString("$it$.skip($p$).findFirst().get()");
                    if (arguments.length == 1 && arguments[0] instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)arguments[0]).getValue()) != null && value.equals(0)) {
                        this.setReplaceByString("$it$.findFirst().get()");
                    }
                    return super.replace(expression, evaluator);
                }
            };
            needSpecifyType = false;
        } else if (methodName.equals("contains")) {
            descriptorBase = new TypeConversionDescriptor("$it$.contains($o$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                    PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
                    LOG.assertTrue(qualifier != null);
                    PsiClassType qualifierType = (PsiClassType)qualifier.getType();
                    LOG.assertTrue(qualifierType != null);
                    PsiType[] parameters = qualifierType.getParameters();
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
                    SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, parameters.length == 1 ? parameters[0] : null, false);
                    String suggestedName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)expression, (boolean)false).names[0];
                    this.setReplaceByString("$it$.anyMatch(" + suggestedName + " -> java.util.Objects.equals(" + suggestedName + ", $o$))");
                    return super.replace(expression, evaluator);
                }
            };
            needSpecifyType = false;
        } else {
            TypeConversionDescriptorFactory base = DESCRIPTORS_MAP.get(methodName);
            if (base != null) {
                TypeConversionDescriptor descriptor = base.create();
                needSpecifyType = base.isChainedMethod();
                if (needSpecifyType && !base.isFluentIterableReturnType()) {
                    conversionType = GuavaConversionUtil.addTypeParameters("java.util.Optional", context.getType(), (PsiElement)context);
                }
                descriptorBase = descriptor;
            }
        }
        if (descriptorBase == null) {
            return FluentIterableConversionUtil.createToCollectionDescriptor(methodName, context);
        }
        if (needSpecifyType) {
            if (conversionType == null) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)(context instanceof PsiMethodCallExpression ? context : context.getParent());
                conversionType = GuavaConversionUtil.addTypeParameters(GuavaTypeConversionDescriptor.isIterable((PsiExpression)methodCall) ? "java.lang.Iterable" : "java.util.stream.Stream", context.getType(), (PsiElement)context);
            }
            descriptorBase.withConversionType(conversionType);
        }
        return descriptorBase;
    }

    @Nullable
    private static TypeConversionDescriptor createDescriptorForAppend(PsiMethod method, PsiExpression context) {
        PsiClass psiClass;
        LOG.assertTrue("append".equals(method.getName()));
        PsiParameterList list = method.getParameterList();
        if (list.getParametersCount() != 1) {
            return null;
        }
        PsiType parameterType = list.getParameters()[0].getType();
        if (parameterType instanceof PsiEllipsisType) {
            return new TypeConversionDescriptor("$q$.append('params*)", "java.util.stream.Stream.concat($q$, java.util.Arrays.asList($params$).stream())");
        }
        if (parameterType instanceof PsiClassType && (psiClass = PsiTypesUtil.getPsiClass((PsiType)parameterType)) != null && "java.lang.Iterable".equals(psiClass.getQualifiedName())) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)(context instanceof PsiMethodCallExpression ? context : context.getParent());
            PsiExpression expression = methodCall.getArgumentList().getExpressions()[0];
            boolean isCollection = InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)expression.getType()), (String)"java.util.Collection");
            String argTemplate = isCollection ? "$arg$.stream()" : "java.util.stream.StreamSupport.stream($arg$.spliterator(), false)";
            return new TypeConversionDescriptor("$q$.append($arg$)", "java.util.stream.Stream.concat($q$," + argTemplate + ")");
        }
        return null;
    }

    @Nullable
    public static GuavaChainedConversionDescriptor buildCompoundDescriptor(PsiMethodCallExpression expression, PsiType to, TypeMigrationLabeler labeler) {
        PsiMethod method;
        SmartList methodDescriptors = new SmartList();
        NotNullLazyValue<TypeConversionRule> optionalDescriptor = new NotNullLazyValue<TypeConversionRule>(){

            @NotNull
            protected TypeConversionRule compute() {
                for (TypeConversionRule rule : (TypeConversionRule[])TypeConversionRule.EP_NAME.getExtensions()) {
                    if (!(rule instanceof GuavaOptionalConversionRule)) continue;
                    TypeConversionRule typeConversionRule = rule;
                    if (typeConversionRule == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule$5", "compute"));
                    }
                    return typeConversionRule;
                }
                throw new RuntimeException("GuavaOptionalConversionRule extension is not found");
            }
        };
        PsiMethodCallExpression current = expression;
        while ((method = current.resolveMethod()) != null) {
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) break;
            TypeConversionDescriptorBase descriptor = null;
            if (FLUENT_ITERABLE.equals(containingClass.getQualifiedName()) ? (descriptor = GuavaFluentIterableConversionRule.getOneMethodDescriptor(methodName, method, current.getType(), null, (PsiExpression)current)) == null : "com.google.common.base.Optional".equals(containingClass.getQualifiedName()) && (descriptor = ((TypeConversionRule)optionalDescriptor.getValue()).findConversion(null, null, (PsiMember)method, (PsiExpression)current.getMethodExpression(), labeler)) == null) {
                return null;
            }
            if (descriptor == null) {
                GuavaFluentIterableConversionRule.addToMigrateChainQualifier(labeler, (PsiExpression)current);
                break;
            }
            methodDescriptors.add(descriptor);
            PsiExpression qualifier = current.getMethodExpression().getQualifierExpression();
            if (qualifier instanceof PsiMethodCallExpression) {
                current = (PsiMethodCallExpression)qualifier;
                continue;
            }
            if (method.hasModifierProperty("static")) {
                if (!CHAIN_HEAD_METHODS.contains(methodName)) {
                    return null;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass != null && FLUENT_ITERABLE.equals(aClass.getQualifiedName())) break;
                return null;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiVariable) {
                GuavaFluentIterableConversionRule.addToMigrateChainQualifier(labeler, qualifier);
                break;
            }
            return null;
        }
        return new GuavaChainedConversionDescriptor((List)methodDescriptors, to);
    }

    private static void addToMigrateChainQualifier(TypeMigrationLabeler labeler, PsiExpression qualifier) {
        boolean isFluentIterable;
        PsiClass qClass = PsiTypesUtil.getPsiClass((PsiType)qualifier.getType());
        if (qClass != null && ((isFluentIterable = FLUENT_ITERABLE.equals(qClass.getQualifiedName())) || "com.google.common.base.Optional".equals(qClass.getQualifiedName()))) {
            labeler.migrateExpressionType(qualifier, GuavaConversionUtil.addTypeParameters(isFluentIterable ? "java.util.stream.Stream" : "java.util.Optional", qualifier.getType(), (PsiElement)qualifier), qualifier.getParent(), false, false);
        }
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        if (FLUENT_ITERABLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "ruleFromClass"));
        }
        return FLUENT_ITERABLE;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        if ("java.util.stream.Stream" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule", "ruleToClass"));
        }
        return "java.util.stream.Stream";
    }

    static {
        DESCRIPTORS_MAP.put("skip", new TypeConversionDescriptorFactory("$q$.skip($p$)", "$q$.skip($p$)", false, true, true));
        DESCRIPTORS_MAP.put("limit", new TypeConversionDescriptorFactory("$q$.limit($p$)", "$q$.limit($p$)", false, true, true));
        DESCRIPTORS_MAP.put("first", new TypeConversionDescriptorFactory("$q$.first()", "$q$.findFirst()", false, true, false));
        DESCRIPTORS_MAP.put("transform", new TypeConversionDescriptorFactory("$q$.transform($params$)", "$q$.map($params$)", true, true, true));
        DESCRIPTORS_MAP.put("allMatch", new TypeConversionDescriptorFactory("$it$.allMatch($c$)", "$it$.allMatch($c$)", true));
        DESCRIPTORS_MAP.put("anyMatch", new TypeConversionDescriptorFactory("$it$.anyMatch($c$)", "$it$.anyMatch($c$)", true));
        DESCRIPTORS_MAP.put("firstMatch", new TypeConversionDescriptorFactory("$it$.firstMatch($p$)", "$it$.filter($p$).findFirst()", true, true, false));
        DESCRIPTORS_MAP.put("size", new TypeConversionDescriptorFactory("$it$.size()", "(int) $it$.count()", false));
    }

    private static class GuavaChainedConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final List<TypeConversionDescriptorBase> myMethodDescriptors;
        private final PsiType myToType;

        private GuavaChainedConversionDescriptor(List<TypeConversionDescriptorBase> descriptors, PsiType to) {
            this.myMethodDescriptors = new ArrayList<TypeConversionDescriptorBase>(descriptors);
            Collections.reverse(this.myMethodDescriptors);
            this.myToType = to;
        }

        @Override
        public PsiExpression replace(@NotNull PsiExpression expression, TypeEvaluator evaluator) throws IncorrectOperationException {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFluentIterableConversionRule$GuavaChainedConversionDescriptor", "replace"));
            }
            Stack methodChainStack = new Stack();
            PsiMethodCallExpression current = (PsiMethodCallExpression)expression;
            while (current != null) {
                methodChainStack.add((Object)current);
                PsiExpression qualifier = current.getMethodExpression().getQualifierExpression();
                current = qualifier instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)qualifier : null;
            }
            if (methodChainStack.size() != this.myMethodDescriptors.size()) {
                return expression;
            }
            PsiExpression converted = null;
            for (TypeConversionDescriptorBase descriptor : this.myMethodDescriptors) {
                PsiMethodCallExpression toConvert = (PsiMethodCallExpression)methodChainStack.pop();
                converted = descriptor.replace((PsiExpression)toConvert, evaluator);
            }
            return converted;
        }

        @Override
        @Nullable
        public PsiType conversionType() {
            return this.myToType;
        }
    }

    static class TypeConversionDescriptorFactory {
        private final String myStringToReplace;
        private final String myReplaceByString;
        private final boolean myWithLambdaParameter;
        private final boolean myChainedMethod;
        private final boolean myFluentIterableReturnType;

        public TypeConversionDescriptorFactory(String stringToReplace, String replaceByString, boolean withLambdaParameter) {
            this(stringToReplace, replaceByString, withLambdaParameter, false, false);
        }

        public TypeConversionDescriptorFactory(@NonNls String stringToReplace, @NonNls String replaceByString, boolean withLambdaParameter, boolean chainedMethod, boolean fluentIterableReturnType) {
            this.myStringToReplace = stringToReplace;
            this.myReplaceByString = replaceByString;
            this.myWithLambdaParameter = withLambdaParameter;
            this.myChainedMethod = chainedMethod;
            this.myFluentIterableReturnType = fluentIterableReturnType;
        }

        public TypeConversionDescriptor create() {
            GuavaTypeConversionDescriptor descriptor = new GuavaTypeConversionDescriptor(this.myStringToReplace, this.myReplaceByString);
            if (!this.myWithLambdaParameter) {
                descriptor = descriptor.setConvertParameterAsLambda(false);
            }
            return descriptor;
        }

        public boolean isChainedMethod() {
            return this.myChainedMethod;
        }

        public boolean isFluentIterableReturnType() {
            return this.myFluentIterableReturnType;
        }
    }
}

