/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.actions;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpellingPopupActionGroup
extends ActionGroup {
    public SpellingPopupActionGroup() {
    }

    public SpellingPopupActionGroup(String shortName, boolean popup) {
        super(shortName, popup);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e != null) {
            AnAction[] children2 = SpellingPopupActionGroup.findActions(e);
            if (children2.length == 0) {
                e.getPresentation().setEnabled(false);
            }
            if (children2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/actions/SpellingPopupActionGroup", "getChildren"));
            }
            return children2;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/actions/SpellingPopupActionGroup", "getChildren"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    private static AnAction[] findActions(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spellchecker/actions/SpellingPopupActionGroup", "findActions"));
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project2 = (Project)e.getData(LangDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(LangDataKeys.EDITOR);
        if (psiFile != null && project2 != null && editor != null) {
            List<HighlightInfo.IntentionActionDescriptor> quickFixes = ShowIntentionsPass.getAvailableActions(editor, psiFile, -1);
            HashMap<Anchor, List<AnAction>> children2 = new HashMap<Anchor, List<AnAction>>();
            ArrayList<Object> first = new ArrayList<Object>();
            children2.put(Anchor.FIRST, first);
            ArrayList last = new ArrayList();
            children2.put(Anchor.LAST, last);
            SpellingPopupActionGroup.extractActions(quickFixes, children2);
            if (first.size() > 0 && last.size() > 0) {
                first.add(new Separator());
            }
            first.addAll(last);
            if (first.size() > 0) {
                AnAction[] anActionArray = first.toArray(new AnAction[first.size()]);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/actions/SpellingPopupActionGroup", "findActions"));
                }
                return anActionArray;
            }
        }
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/actions/SpellingPopupActionGroup", "findActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    private static void extractActions(List<HighlightInfo.IntentionActionDescriptor> descriptors, Map<Anchor, List<AnAction>> actions) {
        for (HighlightInfo.IntentionActionDescriptor actionDescriptor : descriptors) {
            QuickFixWrapper wrapper;
            LocalQuickFix localQuickFix;
            IntentionAction action = actionDescriptor.getAction();
            if (!(action instanceof QuickFixWrapper) || !((localQuickFix = (wrapper = (QuickFixWrapper)action).getFix()) instanceof SpellCheckerQuickFix)) continue;
            SpellCheckerQuickFix spellCheckerQuickFix = (SpellCheckerQuickFix)localQuickFix;
            Anchor anchor = spellCheckerQuickFix.getPopupActionAnchor();
            SpellCheckerIntentionAction popupAction = new SpellCheckerIntentionAction(action);
            List<AnAction> list = actions.get(anchor);
            if (list == null) continue;
            list.add(popupAction);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (e != null && e.getPresentation().isVisible() && SpellingPopupActionGroup.findActions(e).length == 0) {
            e.getPresentation().setVisible(false);
        }
    }

    private static class SpellCheckerIntentionAction
    extends AnAction {
        private static final Logger LOGGER = Logger.getInstance((String)"#SpellCheckerAction");
        private final IntentionAction intention;

        public SpellCheckerIntentionAction(IntentionAction intention) {
            super(intention.getText());
            this.intention = intention;
        }

        public void actionPerformed(AnActionEvent e) {
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Project project2 = (Project)e.getData(LangDataKeys.PROJECT);
            Editor editor = (Editor)e.getData(LangDataKeys.EDITOR);
            if (psiFile != null && project2 != null && editor != null) {
                ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project2, () -> {
                    try {
                        this.intention.invoke(project2, editor, psiFile);
                    }
                    catch (IncorrectOperationException ex) {
                        LOGGER.error((Throwable)ex);
                    }
                }, e.getPresentation().getText(), (Object)e.getActionManager().getId((AnAction)this)));
            }
        }
    }
}

