/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.TestLocator;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/testIntegration/SingleTestEntry;", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "url", "", "magnitude", "Lcom/intellij/execution/testframework/sm/runner/states/TestStateInfo$Magnitude;", "runDate", "Ljava/util/Date;", "(Ljava/lang/String;Lcom/intellij/execution/testframework/sm/runner/states/TestStateInfo$Magnitude;Ljava/util/Date;)V", "getMagnitude", "()Lcom/intellij/execution/testframework/sm/runner/states/TestStateInfo$Magnitude;", "presentation", "Lorg/jetbrains/annotations/NotNull;", "getPresentation", "()Ljava/lang/String;", "getRunDate", "()Ljava/util/Date;", "testsUrls", "", "getTestsUrls", "()Ljava/util/List;", "getUrl", "navigatableElement", "Lcom/intellij/psi/PsiElement;", "locator", "Lcom/intellij/testIntegration/TestLocator;", "run", "", "runner", "Lcom/intellij/testIntegration/RecentTestRunner;", "execution-impl"})
public class SingleTestEntry
implements RecentTestsPopupEntry {
    @NotNull
    private final String presentation;
    @NotNull
    private final List<String> testsUrls;
    @NotNull
    private final String url;
    @NotNull
    private final TestStateInfo.Magnitude magnitude;
    @NotNull
    private final Date runDate;

    @Override
    @NotNull
    public String getPresentation() {
        return this.presentation;
    }

    @Override
    @NotNull
    public List<String> getTestsUrls() {
        return this.testsUrls;
    }

    @Override
    public void run(@NotNull RecentTestRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)runner, (String)"runner");
        runner.run(this.url);
    }

    @Override
    @Nullable
    public PsiElement navigatableElement(@NotNull TestLocator locator) {
        Intrinsics.checkParameterIsNotNull((Object)locator, (String)"locator");
        Location location = locator.getLocation(this.url);
        return location != null ? location.getPsiElement() : null;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public TestStateInfo.Magnitude getMagnitude() {
        return this.magnitude;
    }

    @Override
    @NotNull
    public Date getRunDate() {
        return this.runDate;
    }

    public SingleTestEntry(@NotNull String url, @NotNull TestStateInfo.Magnitude magnitude, @NotNull Date runDate) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)magnitude, (String)"magnitude");
        Intrinsics.checkParameterIsNotNull((Object)runDate, (String)"runDate");
        this.url = url;
        this.magnitude = magnitude;
        this.runDate = runDate;
        this.presentation = VirtualFileManager.extractPath((String)this.url);
        this.testsUrls = CollectionsKt.listOf((Object)this.url);
    }
}

