/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;

public class ExternalClasspathClassLoader
extends URLClassLoader {
    private ExternalClasspathClassLoader(URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseUrls(String classpathFilePath) {
        LinkedHashSet<String> roots = new LinkedHashSet<String>();
        File file2 = new File(classpathFilePath);
        try {
            try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                while (reader.ready()) {
                    roots.add(reader.readLine());
                }
            }
            return roots.toArray(new String[roots.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getRoots() {
        String classPathFilePath = System.getProperty("classpath.file");
        return classPathFilePath != null ? ExternalClasspathClassLoader.parseUrls(classPathFilePath) : null;
    }

    public static String[] getExcludeRoots() {
        try {
            String classPathFilePath = System.getProperty("exclude.tests.roots.file");
            return classPathFilePath != null ? ExternalClasspathClassLoader.parseUrls(classPathFilePath) : null;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static void install() {
        try {
            URL[] urls = ExternalClasspathClassLoader.parseUrls();
            if (urls != null) {
                Thread.currentThread().setContextClassLoader(new ExternalClasspathClassLoader(urls));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static URL[] parseUrls() {
        try {
            String[] roots = ExternalClasspathClassLoader.getRoots();
            if (roots == null) {
                return null;
            }
            URL[] urls = new URL[roots.length];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File(roots[i]).toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

