/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredIconImpl<T>
implements DeferredIcon,
RetrievableIcon,
ScalableIcon {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.DeferredIconImpl");
    private static final int MIN_AUTO_UPDATE_MILLIS = 950;
    private static final RepaintScheduler ourRepaintScheduler = new RepaintScheduler();
    @NotNull
    private volatile Icon myDelegateIcon;
    private Function<T, Icon> myEvaluator;
    private volatile boolean myIsScheduled;
    private T myParam;
    private static final Icon EMPTY_ICON = JBUI.emptyIcon((int)16);
    private final boolean myNeedReadAction;
    private boolean myDone;
    private final boolean myAutoUpdatable;
    private long myLastCalcTime;
    private long myLastTimeSpent;
    private float myScale;
    private Icon myOriginalDeferredIcon;
    private static final Executor ourIconsCalculatingExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((int)1);
    private final IconListener<T> myEvalListener;
    private static final TransferToEDTQueue<Runnable> ourLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"Deferred icon later invocator", (int)200);

    public Icon scale(float scaleFactor) {
        if (scaleFactor != this.myScale) {
            this.myScale = scaleFactor;
            this.myDelegateIcon = ((ScalableIcon)this.myDelegateIcon).scale(this.myScale);
        }
        return this;
    }

    public DeferredIconImpl(Icon baseIcon, T param, @NotNull Function<T, Icon> evaluator, @NotNull IconListener<T> listener2, boolean autoUpdatable) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        this(baseIcon, param, true, evaluator, listener2, autoUpdatable);
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull Function<T, Icon> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        this(baseIcon, param, needReadAction, evaluator, null, false);
    }

    private DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull Function<T, Icon> evaluator, @Nullable IconListener<T> listener2, boolean autoUpdatable) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        this.myScale = 1.0f;
        this.myOriginalDeferredIcon = null;
        this.myParam = param;
        this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
        this.myEvalListener = listener2;
        this.myAutoUpdatable = autoUpdatable;
        this.checkDelegationDepth();
    }

    private void checkDelegationDepth() {
        int depth;
        DeferredIconImpl each = this;
        for (depth = 0; each.myDelegateIcon instanceof DeferredIconImpl && depth < 50; ++depth) {
            each = (DeferredIconImpl)((Object)each.myDelegateIcon);
        }
        if (depth >= 50) {
            LOG.error("Too deep deferred icon nesting");
        }
    }

    @NotNull
    private static Icon nonNull(Icon icon) {
        Icon icon2 = icon == null ? EMPTY_ICON : icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl", "nonNull"));
        }
        return icon2;
    }

    public void paintIcon(Component c, @NotNull Graphics g, int x, int y) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/DeferredIconImpl", "paintIcon"));
        }
        if (!(this.myDelegateIcon instanceof DeferredIconImpl) || !(((DeferredIconImpl)((Object)this.myDelegateIcon)).myDelegateIcon instanceof DeferredIconImpl)) {
            this.myDelegateIcon.paintIcon(c, g, x, y);
        }
        if (this.isDone() || this.myIsScheduled || PowerSaveMode.isEnabled()) {
            return;
        }
        this.myIsScheduled = true;
        Component target = DeferredIconImpl.getTarget(c);
        Container paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c);
        Rectangle paintingParentRec = paintingParent == null ? null : ((PaintingParent)paintingParent).getChildRec(c);
        ourIconsCalculatingExecutor.execute(() -> {
            Icon result2;
            int oldWidth = this.myDelegateIcon.getIconWidth();
            Icon[] evaluated = new Icon[1];
            long startTime = System.currentTimeMillis();
            if (this.myNeedReadAction) {
                boolean result3 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    IconDeferrerImpl.evaluateDeferred(() -> {
                        evaluated[0] = this.evaluate();
                    });
                    if (this.myAutoUpdatable) {
                        this.myLastCalcTime = System.currentTimeMillis();
                        this.myLastTimeSpent = this.myLastCalcTime - startTime;
                    }
                });
                if (!result3) {
                    this.myIsScheduled = false;
                    return;
                }
            } else {
                IconDeferrerImpl.evaluateDeferred(() -> {
                    evaluated[0] = this.evaluate();
                });
                if (this.myAutoUpdatable) {
                    this.myLastCalcTime = System.currentTimeMillis();
                    this.myLastTimeSpent = this.myLastCalcTime - startTime;
                }
            }
            this.myDelegateIcon = result2 = evaluated[0];
            this.checkDelegationDepth();
            boolean shouldRevalidate = Registry.is((String)"ide.tree.deferred.icon.invalidates.cache") && this.myDelegateIcon.getIconWidth() != oldWidth;
            ourLaterInvocator.offer(() -> {
                TreeUI ui;
                this.setDone(result2);
                Component actualTarget = target;
                if (actualTarget != null && SwingUtilities.getWindowAncestor(actualTarget) == null && ((actualTarget = paintingParent) == null || SwingUtilities.getWindowAncestor(actualTarget) == null)) {
                    actualTarget = null;
                }
                if (actualTarget == null) {
                    return;
                }
                if (shouldRevalidate && actualTarget instanceof JTree && (ui = ((JTree)actualTarget).getUI()) instanceof BasicTreeUI) {
                    ((BasicTreeUI)ui).setLeftChildIndent(UIUtil.getTreeLeftChildIndent());
                }
                if (c == actualTarget) {
                    c.repaint(x, y, this.getIconWidth(), this.getIconHeight());
                } else {
                    DeferredIconImpl.ourRepaintScheduler.pushDirtyComponent(actualTarget, paintingParentRec);
                }
            });
        });
    }

    private static Component getTarget(Component c) {
        Container tabLabel;
        Container box;
        Container table;
        Container tree;
        Container list = SwingUtilities.getAncestorOfClass(JList.class, c);
        Component target = list != null ? list : ((tree = SwingUtilities.getAncestorOfClass(JTree.class, c)) != null ? tree : ((table = SwingUtilities.getAncestorOfClass(JTable.class, c)) != null ? table : ((box = SwingUtilities.getAncestorOfClass(JComboBox.class, c)) != null ? box : ((tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c)) == null ? c : tabLabel))));
        return target;
    }

    void setDone(@NotNull Icon result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/DeferredIconImpl", "setDone"));
        }
        if (this.myEvalListener != null) {
            this.myEvalListener.evalDone(this, this.myParam, result2);
        }
        this.myDone = true;
        if (!this.myAutoUpdatable) {
            this.myEvaluator = null;
            this.myParam = null;
        }
    }

    @Nullable
    public Icon retrieveIcon() {
        return this.isDone() ? this.myDelegateIcon : this.evaluate();
    }

    @NotNull
    public Icon evaluate() {
        Icon result2;
        try {
            result2 = DeferredIconImpl.nonNull((Icon)this.myEvaluator.fun(this.myParam));
        }
        catch (IndexNotReadyException e) {
            result2 = EMPTY_ICON;
        }
        if (Holder.CHECK_CONSISTENCY) {
            this.checkDoesntReferenceThis(result2);
        }
        if (this.myScale != 1.0f && result2 instanceof ScalableIcon) {
            result2 = ((ScalableIcon)result2).scale(this.myScale);
        }
        Icon icon = result2;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl", "evaluate"));
        }
        return icon;
    }

    private void checkDoesntReferenceThis(Icon icon) {
        block4: {
            block5: {
                block3: {
                    if (icon == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)((Object)icon)).myDelegateIcon);
                    break block4;
                }
                if (!(icon instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon;
            int count = rowIcon.getIconCount();
            for (int i = 0; i < count; ++i) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i));
            }
        }
    }

    public int getIconWidth() {
        return this.myDelegateIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myDelegateIcon.getIconHeight();
    }

    public boolean isDone() {
        if (this.myAutoUpdatable && this.myDone && this.myLastCalcTime > 0L && System.currentTimeMillis() - this.myLastCalcTime > Math.max(950L, 10L * this.myLastTimeSpent)) {
            this.myDone = false;
            this.myIsScheduled = false;
        }
        return this.myDone;
    }

    static boolean equalIcons(Icon icon1, Icon icon2) {
        if (icon1 instanceof DeferredIconImpl) {
            return ((DeferredIconImpl)((Object)icon1)).isDeferredAndEqual(icon2);
        }
        if (icon2 instanceof DeferredIconImpl) {
            return ((DeferredIconImpl)((Object)icon2)).isDeferredAndEqual(icon1);
        }
        return Comparing.equal((Object)icon1, (Object)icon2);
    }

    private boolean isDeferredAndEqual(Icon icon) {
        return icon instanceof DeferredIconImpl && Comparing.equal(this.myParam, ((DeferredIconImpl)((Object)icon)).myParam) && DeferredIconImpl.equalIcons(this.myDelegateIcon, ((DeferredIconImpl)((Object)icon)).myDelegateIcon);
    }

    public String toString() {
        return "Deferred. Base=" + this.myDelegateIcon;
    }

    static interface IconListener<T> {
        public void evalDone(DeferredIconImpl<T> var1, T var2, @NotNull Icon var3);
    }

    private static class RepaintRequest {
        private final Component myComponent;
        private final Rectangle myRectangle;

        private RepaintRequest(@NotNull Component component, Rectangle rectangle) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/DeferredIconImpl$RepaintRequest", "<init>"));
            }
            this.myComponent = component;
            this.myRectangle = rectangle;
        }

        @NotNull
        public Component getComponent() {
            Component component = this.myComponent;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl$RepaintRequest", "getComponent"));
            }
            return component;
        }

        public Rectangle getRectangle() {
            return this.myRectangle;
        }
    }

    private static class RepaintScheduler {
        private final Alarm myAlarm = new Alarm();
        private final Set<RepaintRequest> myQueue = new LinkedHashSet<RepaintRequest>();

        private RepaintScheduler() {
        }

        private void pushDirtyComponent(@NotNull Component c, Rectangle rec) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/DeferredIconImpl$RepaintScheduler", "pushDirtyComponent"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> {
                for (RepaintRequest each : this.myQueue) {
                    Rectangle r = each.getRectangle();
                    if (r == null) {
                        each.getComponent().repaint();
                        continue;
                    }
                    each.getComponent().repaint(r.x, r.y, r.width, r.height);
                }
                this.myQueue.clear();
            }, 50);
            this.myQueue.add(new RepaintRequest(c, rec));
        }
    }

    private static class Holder {
        private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

