/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomHighlightingHelperImpl
extends DomHighlightingHelper {
    public static final DomHighlightingHelperImpl INSTANCE = new DomHighlightingHelperImpl();
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();
    private final DomApplicationComponent myDomApplicationComponent = DomApplicationComponent.getInstance();

    public void runAnnotators(DomElement element, DomElementAnnotationHolder holder, Class<? extends DomElement> rootClass) {
        DomElementsAnnotator annotator2 = this.myDomApplicationComponent.getAnnotator(rootClass);
        if (annotator2 != null) {
            annotator2.annotate(element, holder);
        }
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkRequired(DomElement element, DomElementAnnotationHolder holder) {
        Required required = (Required)element.getAnnotation(Required.class);
        if (required != null) {
            XmlElement xmlElement = element.getXmlElement();
            if (xmlElement == null) {
                if (required.value()) {
                    String xmlElementName = element.getXmlElementName();
                    String namespace = element.getXmlElementNamespace();
                    if (element instanceof GenericAttributeValue) {
                        List<DomElementProblemDescriptor> list = Collections.singletonList(holder.createProblem(element, IdeBundle.message((String)"attribute.0.should.be.defined", (Object[])new Object[]{xmlElementName}), new LocalQuickFix[]{new DefineAttributeQuickFix(xmlElementName, namespace)}));
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkRequired"));
                        }
                        return list;
                    }
                    List<DomElementProblemDescriptor> list = Collections.singletonList(holder.createProblem(element, HighlightSeverity.ERROR, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{xmlElementName}), new LocalQuickFix[]{new AddRequiredSubtagFix(xmlElementName, namespace)}));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkRequired"));
                    }
                    return list;
                }
            } else if (element instanceof GenericDomValue) {
                List list = ContainerUtil.createMaybeSingletonList((Object)DomHighlightingHelperImpl.checkRequiredGenericValue((GenericDomValue)element, required, holder));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkRequired"));
                }
                return list;
            }
        }
        if (DomUtil.hasXml((DomElement)element)) {
            SmartList list = new SmartList();
            DomGenericInfo info = element.getGenericInfo();
            for (AbstractDomChildrenDescription description : info.getChildrenDescriptions()) {
                if (!(description instanceof DomCollectionChildDescription) || !description.getValues(element).isEmpty()) continue;
                DomCollectionChildDescription childDescription = (DomCollectionChildDescription)description;
                Required annotation = (Required)description.getAnnotation(Required.class);
                if (annotation == null || !annotation.value()) continue;
                list.add((Object)holder.createProblem(element, childDescription, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{((DomCollectionChildDescription)description).getXmlElementName()})));
            }
            SmartList smartList = list;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkRequired"));
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkRequired"));
        }
        return list;
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue element, DomElementAnnotationHolder holder) {
        Required required;
        if (StringUtil.isEmpty((String)element.getStringValue()) && (required = (Required)element.getAnnotation(Required.class)) != null && !required.nonEmpty()) {
            List<DomElementProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkResolveProblems"));
            }
            return list;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)element);
        if (valueElement != null && !DomHighlightingHelperImpl.isSoftReference(element)) {
            String errorMessage;
            SmartList list = new SmartList();
            Object[] psiReferences = this.myProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext());
            GenericDomValueReference domReference = (GenericDomValueReference)((Object)ContainerUtil.findInstance((Object[])psiReferences, GenericDomValueReference.class));
            Converter converter = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
            boolean hasBadResolve = false;
            if (domReference == null || !DomHighlightingHelperImpl.isDomResolveOK(element, domReference, converter)) {
                for (Object reference : psiReferences) {
                    if (reference == domReference || !DomHighlightingHelperImpl.hasBadResolve((PsiReference)reference)) continue;
                    hasBadResolve = true;
                    list.add((Object)holder.createResolveProblem(element, (PsiReference)reference));
                }
                boolean isResolvingConverter = converter instanceof ResolvingConverter;
                if (!hasBadResolve && (domReference != null || isResolvingConverter && DomHighlightingHelperImpl.hasBadResolve(domReference = new GenericDomValueReference(element)))) {
                    hasBadResolve = true;
                    String errorMessage2 = converter.getErrorMessage(element.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element)));
                    if (errorMessage2 != null) {
                        list.add((Object)holder.createResolveProblem(element, domReference));
                    }
                }
            }
            if (!hasBadResolve && psiReferences.length == 0 && element.getValue() == null && !PsiTreeUtil.hasErrorElements((PsiElement)valueElement) && (errorMessage = converter.getErrorMessage(element.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element)))) != null) {
                list.add((Object)holder.createProblem((DomElement)element, errorMessage, new LocalQuickFix[0]));
            }
            SmartList smartList = list;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkResolveProblems"));
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkResolveProblems"));
        }
        return list;
    }

    private static boolean isDomResolveOK(GenericDomValue element, GenericDomValueReference domReference, Converter converter) {
        return !DomHighlightingHelperImpl.hasBadResolve((PsiReference)domReference) || converter instanceof ResolvingConverter && ((ResolvingConverter)converter).getAdditionalVariants(domReference.getConvertContext()).contains(element.getStringValue());
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkNameIdentity(DomElement element, DomElementAnnotationHolder holder) {
        DomElement domElement;
        String elementName = ElementPresentationManager.getElementName((Object)element);
        if (StringUtil.isNotEmpty((String)elementName) && (domElement = DomUtil.findDuplicateNamedValue((DomElement)element, (String)elementName)) != null) {
            String typeName = ElementPresentationManager.getTypeNameForObject((Object)element);
            GenericDomValue genericDomValue = domElement.getGenericInfo().getNameDomElement(element);
            if (genericDomValue != null) {
                List<DomElementProblemDescriptor> list = Collections.singletonList(holder.createProblem((DomElement)genericDomValue, DomUtil.getFile((DomElement)domElement).equals(DomUtil.getFile((DomElement)element)) ? IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{typeName}) : IdeBundle.message((String)"model.highlighting.identity.in.other.file", (Object[])new Object[]{typeName, domElement.getXmlTag().getContainingFile().getName()}), new LocalQuickFix[0]));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkNameIdentity"));
                }
                return list;
            }
        }
        List<DomElementProblemDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl", "checkNameIdentity"));
        }
        return list;
    }

    private static boolean hasBadResolve(PsiReference reference) {
        return XmlHighlightVisitor.hasBadResolve(reference, true);
    }

    private static boolean isSoftReference(GenericDomValue value) {
        Resolve resolve2 = (Resolve)value.getAnnotation(Resolve.class);
        if (resolve2 != null && resolve2.soft()) {
            return true;
        }
        Convert convert = (Convert)value.getAnnotation(Convert.class);
        if (convert != null && convert.soft()) {
            return true;
        }
        Referencing referencing = (Referencing)value.getAnnotation(Referencing.class);
        return referencing != null && referencing.soft();
    }

    @Nullable
    private static DomElementProblemDescriptor checkRequiredGenericValue(GenericDomValue child, Required required, DomElementAnnotationHolder annotator2) {
        String stringValue = child.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (required.nonEmpty() && DomHighlightingHelperImpl.isEmpty(child, stringValue)) {
            return annotator2.createProblem((DomElement)child, IdeBundle.message((String)"value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        if (required.identifier() && !DomHighlightingHelperImpl.isIdentifier(stringValue)) {
            return annotator2.createProblem((DomElement)child, IdeBundle.message((String)"value.must.be.identifier", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        return null;
    }

    private static boolean isIdentifier(String s) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(GenericDomValue child, String stringValue) {
        XmlAttributeValue value;
        if (stringValue.trim().length() != 0) {
            return false;
        }
        return !(child instanceof GenericAttributeValue) || (value = ((GenericAttributeValue)child).getXmlAttributeValue()) == null || !value.getTextRange().isEmpty();
    }

    private static class AddRequiredSubtagFix
    implements LocalQuickFix {
        private final String tagName;
        private final String tagNamespace;

        private AddRequiredSubtagFix(@NotNull String _tagName, @NotNull String _tagNamespace) {
            if (_tagName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_tagName", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "<init>"));
            }
            if (_tagNamespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_tagNamespace", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "<init>"));
            }
            this.tagName = _tagName;
            this.tagNamespace = _tagNamespace;
        }

        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)"insert.required.tag.fix", (Object[])new Object[]{this.tagName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"insert.required.tag.fix.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix", "applyFix"));
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
            if (tag != null) {
                this.doFix(tag);
            }
        }

        private void doFix(XmlTag parentTag) {
            if (!FileModificationService.getInstance().prepareFileForWrite(parentTag.getContainingFile())) {
                return;
            }
            try {
                parentTag.add((PsiElement)parentTag.createChildTag(this.tagName, this.tagNamespace, null, false));
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

