/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsRootsRegistry;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogHashMapImpl
implements Disposable,
VcsLogHashMap {
    public static final VcsLogHashMap EMPTY = new VcsLogHashMap(){

        @Override
        public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "getCommitIndex"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "getCommitIndex"));
            }
            return 0;
        }

        @Override
        @NotNull
        public CommitId getCommitId(int commitIndex) {
            throw new UnsupportedOperationException("Illegal access to empty hash map by index " + commitIndex);
        }

        @Override
        @Nullable
        public CommitId findCommitId(@NotNull Condition<CommitId> string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "findCommitId"));
            }
            return null;
        }

        @Override
        public void flush() {
        }
    };
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogHashMap.class);
    @NotNull
    private static final String LOG_KIND = "hashes";
    private static final int VERSION = 2;
    private static final int NO_INDEX = -1;
    @NotNull
    private final PersistentEnumerator<CommitId> myPersistentEnumerator;
    @NotNull
    private final Consumer<Exception> myExceptionReporter;

    public VcsLogHashMapImpl(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull Consumer<Exception> exceptionReporter, @NotNull Disposable parent) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        if (exceptionReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionReporter", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        this.myExceptionReporter = exceptionReporter;
        this.myPersistentEnumerator = PersistentUtil.createPersistentEnumerator(new MyCommitIdKeyDescriptor(project2), LOG_KIND, PersistentUtil.calcLogId(project2, logProviders), 2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myPersistentEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getOrPut"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getOrPut"));
        }
        return this.myPersistentEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getCommitIndex"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getCommitIndex"));
        }
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume((Object)e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                this.myExceptionReporter.consume((Object)new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId;
        }
        catch (IOException e) {
            this.myExceptionReporter.consume((Object)e);
            return null;
        }
    }

    @Override
    @Nullable
    public CommitId findCommitId(final @NotNull Condition<CommitId> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "findCommitId"));
        }
        try {
            final Ref hashRef = Ref.create();
            this.myPersistentEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId) {
                    boolean matches = condition.value((Object)commitId);
                    if (matches) {
                        hashRef.set((Object)commitId);
                    }
                    return matches;
                }
            });
            return (CommitId)hashRef.get();
        }
        catch (IOException e) {
            this.myExceptionReporter.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.myPersistentEnumerator.force();
    }

    public void dispose() {
        try {
            this.myPersistentEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final VcsRootsRegistry myRootsRegistry;

        public MyCommitIdKeyDescriptor(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMapImpl$MyCommitIdKeyDescriptor", "<init>"));
            }
            this.myRootsRegistry = (VcsRootsRegistry)ServiceManager.getService((Project)project2, VcsRootsRegistry.class);
        }

        public void save(@NotNull DataOutput out, CommitId value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsLogHashMapImpl$MyCommitIdKeyDescriptor", "save"));
            }
            ((HashImpl)value.getHash()).write(out);
            out.writeInt(this.myRootsRegistry.getId(value.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsLogHashMapImpl$MyCommitIdKeyDescriptor", "read"));
            }
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRootsRegistry.getRootById(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value) {
            return value.hashCode();
        }

        public boolean isEqual(CommitId val1, CommitId val2) {
            return val1.equals((Object)val2);
        }
    }
}

