/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.vcs.log.impl.VcsRootsRegistry;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootsRegistryImpl
implements VcsRootsRegistry,
Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsRootsRegistry.class);
    @NotNull
    private static final String LOG_KIND = "roots";
    @NotNull
    private final PersistentStringEnumerator myEnumerator;
    private static final int VERSION = 0;

    public VcsRootsRegistryImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsRootsRegistryImpl", "<init>"));
        }
        this.myEnumerator = VcsRootsRegistryImpl.createEnumerator(project2);
    }

    @NotNull
    private static PersistentStringEnumerator createEnumerator(@NotNull Project project2) {
        PersistentStringEnumerator persistentStringEnumerator;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsRootsRegistryImpl", "createEnumerator"));
        }
        try {
            persistentStringEnumerator = PersistentUtil.createPersistentStringEnumerator(LOG_KIND, project2.getName() + "." + project2.getBaseDir().getPath().hashCode(), 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create persistent storage for vcs roots.", e);
        }
        if (persistentStringEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsRootsRegistryImpl", "createEnumerator"));
        }
        return persistentStringEnumerator;
    }

    public void dispose() {
        try {
            this.myEnumerator.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public int getId(@NotNull VirtualFile root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsRootsRegistryImpl", "getId"));
        }
        return this.myEnumerator.enumerate(root.getPath());
    }

    @Override
    @Nullable
    public VirtualFile getRootById(int id) throws IOException {
        String path = this.myEnumerator.valueOf(id);
        if (path == null) {
            throw new RuntimeException("Can not find path by id " + id);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 == null) {
            LOG.info("Can not find file by path " + path);
            return null;
        }
        return file2;
    }
}

