/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsConfigurationBase
implements PersistentStateComponent<JsonSchemaMappingsConfigurationBase> {
    private static final Comparator<Item> COMPARATOR = (o1, o2) -> {
        if (o1.isPattern() != o2.isPattern()) {
            return o1.isPattern() ? -1 : 1;
        }
        if (o1.isDirectory() != o2.isDirectory()) {
            return o1.isDirectory() ? -1 : 1;
        }
        return o1.getPath().compareToIgnoreCase(o2.getPath());
    };
    @Tag(value="state")
    @AbstractCollection(surroundWithTag=false)
    protected final Map<String, SchemaInfo> myState = new TreeMap<String, SchemaInfo>();

    @Nullable
    public JsonSchemaMappingsConfigurationBase getState() {
        return this;
    }

    public void loadState(JsonSchemaMappingsConfigurationBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public Map<String, SchemaInfo> getStateMap() {
        return this.myState;
    }

    public void setState(@NotNull Map<String, SchemaInfo> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase", "setState"));
        }
        this.myState.clear();
        this.myState.putAll(state);
    }

    public File convertToAbsoluteFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase", "convertToAbsoluteFile"));
        }
        return new File(path);
    }

    public void addSchema(@NotNull SchemaInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase", "addSchema"));
        }
        this.myState.put(info.getName(), info);
    }

    public void removeSchema(@NotNull SchemaInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase", "removeSchema"));
        }
        this.myState.remove(info.getName());
    }

    public static class Item {
        private String myPath;
        private boolean myIsPattern;
        private boolean myIsDirectory;

        public Item() {
        }

        public Item(String path, boolean isPattern, boolean isDirectory) {
            this.myPath = path;
            this.myIsPattern = isPattern;
            this.myIsDirectory = isDirectory;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public boolean isPattern() {
            return this.myIsPattern;
        }

        public void setPattern(boolean pattern) {
            this.myIsPattern = pattern;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }

        public void setDirectory(boolean directory) {
            this.myIsDirectory = directory;
        }

        public String getPresentation() {
            String prefix = this.myIsPattern ? "Pattern: " : (this.myIsDirectory ? "Directory: " : "File: ");
            return prefix + this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.myIsPattern != item.myIsPattern) {
                return false;
            }
            if (this.myIsDirectory != item.myIsDirectory) {
                return false;
            }
            return !(this.myPath != null ? !this.myPath.equals(item.myPath) : item.myPath != null);
        }

        public int hashCode() {
            int result2 = this.myPath != null ? this.myPath.hashCode() : 0;
            result2 = 31 * result2 + (this.myIsPattern ? 1 : 0);
            result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
            return result2;
        }
    }

    public static class SchemaInfo {
        private String myName;
        private String myRelativePathToSchema;
        private boolean myApplicationLevel;
        private List<Item> myPatterns;

        public SchemaInfo() {
            this.myPatterns = new ArrayList<Item>();
        }

        public SchemaInfo(@NotNull String name, @NotNull String relativePathToSchema, boolean applicationLevel, List<Item> patterns) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "<init>"));
            }
            if (relativePathToSchema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePathToSchema", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "<init>"));
            }
            this.myPatterns = new ArrayList<Item>();
            this.myName = name;
            this.myRelativePathToSchema = relativePathToSchema;
            this.myApplicationLevel = applicationLevel;
            this.myPatterns = new ArrayList<Item>();
            if (patterns != null) {
                this.myPatterns.addAll(patterns);
            }
            Collections.sort(this.myPatterns, COMPARATOR);
        }

        public String getName() {
            return this.myName;
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "setName"));
            }
            this.myName = name;
        }

        public String getRelativePathToSchema() {
            return this.myRelativePathToSchema;
        }

        public void setRelativePathToSchema(String relativePathToSchema) {
            this.myRelativePathToSchema = relativePathToSchema;
        }

        public boolean isApplicationLevel() {
            return this.myApplicationLevel;
        }

        public void setApplicationLevel(boolean applicationLevel) {
            this.myApplicationLevel = applicationLevel;
        }

        public List<Item> getPatterns() {
            return this.myPatterns;
        }

        public void setPatterns(List<Item> patterns) {
            this.myPatterns = patterns;
        }

        public void addItem(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "addItem"));
            }
            this.myPatterns.add(item);
            Collections.sort(this.myPatterns, COMPARATOR);
        }

        public void removeItem(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "removeItem"));
            }
            if (this.myPatterns.remove(item)) {
                Collections.sort(this.myPatterns, COMPARATOR);
            }
        }

        @Nullable
        public VirtualFile getSchemaFile(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurationBase$SchemaInfo", "getSchemaFile"));
            }
            String pathToSchema = FileUtil.toSystemIndependentName((String)this.getRelativePathToSchema());
            List strings = ContainerUtil.filter((Object[])pathToSchema.split("/"), s -> !StringUtil.isEmptyOrSpaces((String)s));
            return VfsUtil.findRelativeFile((VirtualFile)project2.getBaseDir(), (String[])ArrayUtil.toStringArray((Collection)strings));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaInfo info = (SchemaInfo)o;
            if (this.myApplicationLevel != info.myApplicationLevel) {
                return false;
            }
            if (this.myName != null ? !this.myName.equals(info.myName) : info.myName != null) {
                return false;
            }
            if (this.myRelativePathToSchema != null ? !this.myRelativePathToSchema.equals(info.myRelativePathToSchema) : info.myRelativePathToSchema != null) {
                return false;
            }
            return !(this.myPatterns != null ? !this.myPatterns.equals(info.myPatterns) : info.myPatterns != null);
        }

        public int hashCode() {
            int result2 = this.myName != null ? this.myName.hashCode() : 0;
            result2 = 31 * result2 + (this.myRelativePathToSchema != null ? this.myRelativePathToSchema.hashCode() : 0);
            result2 = 31 * result2 + (this.myApplicationLevel ? 1 : 0);
            result2 = 31 * result2 + (this.myPatterns != null ? this.myPatterns.hashCode() : 0);
            return result2;
        }
    }
}

