/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaFileIndex;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaResourcesRootsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonSchemaRefReference((JsonValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement resolveSchemaProperty(PsiElement baseElement, final @Nullable String schemaId, String ref) {
        final Project project2 = baseElement.getProject();
        FileBasedIndex index = FileBasedIndex.getInstance();
        final Ref reference = new Ref();
        GlobalSearchScope filter = schemaId == null ? GlobalSearchScope.fileScope((PsiFile)baseElement.getContainingFile()) : JsonSchemaResourcesRootsProvider.enlarge(project2, GlobalSearchScope.allScope((Project)project2));
        index.processValues(JsonSchemaFileIndex.PROPERTIES_INDEX, (Object)ref, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Integer>(){

            public boolean process(VirtualFile file2, Integer value) {
                if (schemaId != null && !JsonSchemaService.Impl.getEx(project2).checkFileForId(schemaId, file2)) {
                    return true;
                }
                reference.set((Object)Pair.create((Object)file2, (Object)value));
                return false;
            }
        }, filter);
        if (!reference.isNull()) {
            Pair pair = (Pair)reference.get();
            PsiFile file2 = baseElement.getManager().findFile((VirtualFile)pair.getFirst());
            if (file2 != null) {
                return file2.findElementAt(((Integer)pair.getSecond()).intValue());
            }
        }
        return null;
    }

    private static class JsonSchemaRefReference
    extends JsonSchemaBaseReference<JsonValue> {
        public JsonSchemaRefReference(JsonValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @NotNull
        public String getCanonicalText() {
            String string = StringUtil.unquoteString((String)super.getCanonicalText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider$JsonSchemaRefReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String text = this.getCanonicalText();
            String id = null;
            String ref = text.substring(1);
            if (!text.startsWith("#")) {
                int idx = text.indexOf("#");
                if (idx <= 0) {
                    return null;
                }
                id = text.substring(0, idx);
                ref = text.substring(idx + 1);
            }
            return JsonSchemaRefReferenceProvider.resolveSchemaProperty(this.getElement(), id, ref);
        }
    }
}

