/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaRefReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReferenceContributor
extends PsiReferenceContributor {
    private static final PsiElementPattern.Capture<JsonValue> REF_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$ref");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(REF_PATTERN, (PsiReferenceProvider)new JsonSchemaRefReferenceProvider());
    }

    private static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaReferenceContributor", "createPropertyValuePattern"));
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    if (!JsonSchemaReferenceContributor.isSchemaFile((PsiElement)element)) {
                        return false;
                    }
                    if (((JsonValue)element).getParent() instanceof JsonProperty && ((JsonProperty)((JsonValue)element).getParent()).getValue() == element) {
                        return propertyName.equals(((JsonProperty)((JsonValue)element).getParent()).getName());
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static boolean isSchemaFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaReferenceContributor", "isSchemaFile"));
        }
        Project project2 = element.getProject();
        PsiFile file2 = element.getContainingFile();
        if (!JsonSchemaFileType.INSTANCE.equals(file2.getFileType())) {
            return false;
        }
        return file2.getVirtualFile() != null && JsonSchemaMappingsProjectConfiguration.getInstance(project2).isRegisteredSchemaFile(file2.getVirtualFile());
    }
}

