/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingFloatingPointLiteralInspection
extends BaseInspection {
    public boolean ignoreScientificNotation = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("confusing.floating.point.literal.option", new Object[0]), (InspectionProfileEntry)this, "ignoreScientificNotation");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection", "writeSettings"));
        }
        if (this.ignoreScientificNotation) {
            node.addContent(new Element("option").setAttribute("name", "ignoreScientificNotation").setAttribute("value", "true"));
        }
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConfusingFloatingPointLiteralFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingFloatingPointLiteralVisitor();
    }

    private class ConfusingFloatingPointLiteralVisitor
    extends BaseInspectionVisitor {
        private ConfusingFloatingPointLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(literal);
            PsiType type = literal.getType();
            String literalText = literal.getText();
            if (!PsiType.FLOAT.equals((Object)type) && !PsiType.DOUBLE.equals((Object)type) || !this.isConfusing(literalText)) {
                return;
            }
            if (ConfusingFloatingPointLiteralInspection.this.ignoreScientificNotation && StringUtil.containsAnyChar((String)literalText, (String)"EePp")) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }

        private boolean isConfusing(@Nullable CharSequence text) {
            if (text == null) {
                return false;
            }
            int length = text.length();
            if (length < 3) {
                return true;
            }
            boolean hex = true;
            char firstChar = text.charAt(0);
            if (firstChar != '0') {
                if (!StringUtil.isDecimalDigit((char)firstChar)) {
                    return true;
                }
                hex = false;
            }
            char secondChar = text.charAt(1);
            if (hex && secondChar != 'x' && secondChar != 'X') {
                hex = false;
            }
            int index = hex ? 2 : 1;
            char nextChar = text.charAt(index);
            if (hex && !StringUtil.isHexDigit((char)nextChar)) {
                return true;
            }
            while (hex && StringUtil.isHexDigit((char)nextChar) || StringUtil.isDecimalDigit((char)nextChar) || nextChar == '_') {
                if (++index >= length) {
                    return true;
                }
                nextChar = text.charAt(index);
            }
            if (nextChar != '.') {
                return true;
            }
            if (++index >= length) {
                return true;
            }
            nextChar = text.charAt(index);
            return hex ? !StringUtil.isHexDigit((char)nextChar) : !StringUtil.isDecimalDigit((char)nextChar);
        }
    }

    private static class ConfusingFloatingPointLiteralFix
    extends InspectionGadgetsFix {
        private ConfusingFloatingPointLiteralFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.change.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiExpression literalExpression = (PsiExpression)descriptor.getPsiElement();
            String text = literalExpression.getText();
            String newText = ConfusingFloatingPointLiteralFix.getCanonicalForm(text);
            PsiReplacementUtil.replaceExpression(literalExpression, newText);
        }

        private static String getCanonicalForm(@NonNls String text) {
            String prefix;
            String suffix;
            boolean isHexadecimal = text.startsWith("0x") || text.startsWith("0X");
            int breakPoint = text.indexOf(101);
            if (breakPoint < 0) {
                breakPoint = text.indexOf(69);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(102);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(70);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(112);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(80);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(100);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(68);
            }
            if (breakPoint < 0) {
                suffix = "";
                prefix = text;
            } else {
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            }
            int indexPoint = prefix.indexOf(46);
            if (indexPoint < 0) {
                return prefix + ".0" + suffix;
            }
            if (isHexadecimal && indexPoint == 2) {
                return prefix.substring(0, 2) + '0' + prefix.substring(2) + suffix;
            }
            if (indexPoint == 0) {
                return '0' + prefix + suffix;
            }
            return prefix + '0' + suffix;
        }
    }
}

