/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.CommonBundle;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetBackgroundImageDialog
extends DialogWrapper {
    private final String myPropertyTmp;
    private JPanel myRoot;
    private JBRadioButton myEditorRb;
    private JBRadioButton myScaleRb;
    private JBRadioButton myCenterRb;
    private JSlider myOpacitySlider;
    private JSpinner myOpacitySpinner;
    private JPanel myPreviewPanel;
    private ComboboxWithBrowseButton myPathField;
    boolean myAdjusting;
    private String mySelectedPath;
    private Map<String, String> myResults;
    private final SimpleEditorPreview myEditorPreview;
    private final JComponent myIdePreview;

    public SetBackgroundImageDialog(@NotNull Project project2, @Nullable String selectedPath) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/actions/SetBackgroundImageDialog", "<init>"));
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myResults = ContainerUtil.newHashMap();
        this.setTitle("Background Image");
        this.mySelectedPath = selectedPath;
        this.myEditorPreview = SetBackgroundImageDialog.createEditorPreview();
        this.myIdePreview = SetBackgroundImageDialog.createIdePreview();
        this.myPropertyTmp = this.getSystemProp() + "#" + project2.getLocationHash();
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myRoot, () -> IdeBackgroundUtil.createTemporaryBackgroundTransform(this.myPreviewPanel, this.myPropertyTmp, this.getDisposable()));
        this.setupComponents();
        this.restoreRecentImages();
        this.setSelectedPath(this.mySelectedPath);
        this.targetChanged(null);
        this.init();
    }

    private void createUIComponents() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(), 100);
        this.myPathField = new ComboboxWithBrowseButton((JComboBox)comboBox);
    }

    protected void dispose() {
        super.dispose();
        this.myEditorPreview.disposeUIResources();
        System.getProperties().remove(this.myPropertyTmp);
    }

    @NotNull
    private static SimpleEditorPreview createEditorPreview() {
        int index;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        ColorAndFontOptions options = new ColorAndFontOptions();
        options.reset();
        options.selectScheme(scheme.getName());
        ColorSettingsPage[] pages = ColorSettingsPages.getInstance().getRegisteredPages();
        int attempt = 0;
        while (StringUtil.countNewLines((CharSequence)pages[index = (int)Math.round(Math.random() * (double)(pages.length - 1))].getDemoText()) < 8 && ++attempt < 10) {
        }
        SimpleEditorPreview simpleEditorPreview = new SimpleEditorPreview(options, pages[index], false);
        if (simpleEditorPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/actions/SetBackgroundImageDialog", "createEditorPreview"));
        }
        return simpleEditorPreview;
    }

    @NotNull
    private static JComponent createIdePreview() {
        JBLabel jBLabel = new JBLabel(){
            EditorEmptyTextPainter p = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);

            protected Graphics getComponentGraphics(Graphics g) {
                return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(g));
            }

            public void paint(Graphics gg) {
                Graphics g = this.getComponentGraphics(gg);
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.translate(0, -50);
                this.p.paintEmptyText((JComponent)((Object)this), g);
            }
        };
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/actions/SetBackgroundImageDialog", "createIdePreview"));
        }
        return jBLabel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    private String getRecentItemsKey() {
        String string = this.getDimensionServiceKey() + "#recent";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/actions/SetBackgroundImageDialog", "getRecentItemsKey"));
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRoot;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPathField;
    }

    private void setupComponents() {
        AbstractButton button;
        this.myAdjusting = true;
        this.myPreviewPanel.setLayout(new CardLayout());
        this.myPreviewPanel.add((Component)this.myEditorPreview.getPanel(), "editor");
        this.myPreviewPanel.add((Component)this.myIdePreview, "ide");
        ((CardLayout)this.myPreviewPanel.getLayout()).show(this.myPreviewPanel, "editor");
        this.myPathField.getComboBox().setEditable(true);
        this.myPathField.getButton().setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, true, false).withFileFilter(file2 -> ImageFileTypeManager.getInstance().isImage((VirtualFile)file2));
                VirtualFile file3 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)SetBackgroundImageDialog.this.myRoot, null, null);
                if (file3 != null) {
                    SetBackgroundImageDialog.this.setSelectedPath(file3.getPath());
                }
            }
        });
        JTextComponent textComponent = this.getComboEditor();
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (SetBackgroundImageDialog.this.myAdjusting) {
                    return;
                }
                SetBackgroundImageDialog.this.imagePathChanged();
            }
        });
        Enumeration<AbstractButton> e = this.getTargetRbGroup().getElements();
        while (e.hasMoreElements()) {
            button = e.nextElement();
            button.setActionCommand(button.getText());
            button.addItemListener(this::targetChanged);
        }
        e = this.getFillRbGroup().getElements();
        while (e.hasMoreElements()) {
            button = e.nextElement();
            button.setActionCommand(button.getText());
            button.addItemListener(this::fillOrPlaceChanged);
        }
        e = this.getPlaceRbGroup().getElements();
        while (e.hasMoreElements()) {
            button = e.nextElement();
            button.setActionCommand(button.getText());
            button.addItemListener(this::fillOrPlaceChanged);
        }
        ChangeListener opacitySync = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean b;
                if (SetBackgroundImageDialog.this.myAdjusting) {
                    return;
                }
                SetBackgroundImageDialog.this.myAdjusting = true;
                boolean bl = b = e.getSource() == SetBackgroundImageDialog.this.myOpacitySpinner;
                if (b) {
                    int value = (Integer)SetBackgroundImageDialog.this.myOpacitySpinner.getValue();
                    SetBackgroundImageDialog.this.myOpacitySpinner.setValue(Math.min(Math.max(0, value), 100));
                    SetBackgroundImageDialog.this.myOpacitySlider.setValue(value);
                } else {
                    SetBackgroundImageDialog.this.myOpacitySpinner.setValue(SetBackgroundImageDialog.this.myOpacitySlider.getValue());
                }
                SetBackgroundImageDialog.this.myAdjusting = false;
                SetBackgroundImageDialog.this.opacityChanged();
            }
        };
        this.myOpacitySpinner.addChangeListener(opacitySync);
        this.myOpacitySlider.addChangeListener(opacitySync);
        this.myOpacitySlider.setValue(15);
        this.myOpacitySpinner.setValue(15);
        this.myScaleRb.setSelected(true);
        this.myCenterRb.setSelected(true);
        this.myEditorRb.setSelected(true);
        this.myAdjusting = false;
    }

    private void opacityChanged() {
        this.updatePreview();
    }

    private void imagePathChanged() {
        this.updatePreview();
    }

    private void fillOrPlaceChanged(ItemEvent event) {
        this.updatePreview();
    }

    private void targetChanged(ItemEvent event) {
        if (event != null && event.getStateChange() == 2) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySelectedPath)) {
            this.retrieveExistingValue();
        }
        ((CardLayout)this.myPreviewPanel.getLayout()).show(this.myPreviewPanel, this.myEditorRb.isSelected() ? "editor" : "ide");
        if (this.myEditorRb.isSelected()) {
            this.myEditorPreview.updateView();
        }
        this.updatePreview();
    }

    public void setSelectedPath(String path) {
        this.mySelectedPath = path;
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return;
        }
        CollectionComboBoxModel<String> comboModel = this.getComboModel();
        if (!comboModel.contains((Object)path)) {
            comboModel.add((Object)path);
        }
        comboModel.setSelectedItem((Object)path);
        this.getComboEditor().setCaretPosition(0);
    }

    private void retrieveExistingValue() {
        this.myAdjusting = true;
        String prop = this.getSystemProp();
        String value = StringUtil.notNullize((String)this.myResults.get(prop), (String)IdeBackgroundUtil.getBackgroundSpec(prop));
        String[] split = value.split(",");
        int opacity = split.length > 1 ? StringUtil.parseInt((String)split[1], (int)15) : 15;
        String fill = split.length > 2 ? split[2] : "scale";
        String place = split.length > 3 ? split[3] : "center";
        this.setSelectedPath(split[0]);
        this.mySelectedPath = null;
        this.myOpacitySlider.setValue(opacity);
        this.myOpacitySpinner.setValue(opacity);
        SetBackgroundImageDialog.setSelected(this.getFillRbGroup(), fill);
        SetBackgroundImageDialog.setSelected(this.getPlaceRbGroup(), place);
        this.myAdjusting = false;
    }

    public void doCancelAction() {
        this.storeRecentImages();
        super.doCancelAction();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.storeRecentImages();
        String value = this.calcNewValue();
        String prop = this.getSystemProp();
        this.myResults.put(prop, value);
        if (value.startsWith(",")) {
            value = null;
        }
        PropertiesComponent.getInstance().setValue(prop, value);
        IdeBackgroundUtil.repaintAllWindows();
    }

    private void storeRecentImages() {
        List items = this.getComboModel().getItems();
        PropertiesComponent.getInstance().setValue(this.getRecentItemsKey(), StringUtil.join(items.subList(0, Math.min(items.size(), 5)), (String)"\n"));
    }

    private CollectionComboBoxModel<String> getComboModel() {
        return (CollectionComboBoxModel)this.myPathField.getComboBox().getModel();
    }

    private JTextComponent getComboEditor() {
        return (JTextComponent)this.myPathField.getComboBox().getEditor().getEditorComponent();
    }

    private void restoreRecentImages() {
        String value = PropertiesComponent.getInstance().getValue(this.getRecentItemsKey());
        if (value == null) {
            return;
        }
        CollectionComboBoxModel<String> model = this.getComboModel();
        for (String s : value.split("\n")) {
            if (StringUtil.isEmptyOrSpaces((String)s) || model.contains((Object)s)) continue;
            model.add((Object)s);
        }
    }

    private String getSystemProp() {
        return this.myEditorRb.isSelected() ? "idea.background.editor" : "idea.background.frame";
    }

    private void updatePreview() {
        if (this.myAdjusting) {
            return;
        }
        String prop = this.getSystemProp();
        String value = this.calcNewValue();
        System.setProperty(this.myPropertyTmp, value);
        this.myResults.put(prop, value);
        this.myPreviewPanel.validate();
        this.myPreviewPanel.repaint();
        boolean clear = value.startsWith(",");
        this.getOKAction().putValue("Name", clear ? "Clear" : CommonBundle.getOkButtonText());
    }

    @NotNull
    private String calcNewValue() {
        String path = (String)this.myPathField.getComboBox().getEditor().getItem();
        String type = this.getFillRbGroup().getSelection().getActionCommand().replace('-', '_');
        String place = this.getPlaceRbGroup().getSelection().getActionCommand().replace('-', '_');
        String string = path.trim() + "," + this.myOpacitySpinner.getValue() + "," + (type + "," + place).toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/actions/SetBackgroundImageDialog", "calcNewValue"));
        }
        return string;
    }

    private static void setSelected(ButtonGroup group, String fill) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            String s = button.getActionCommand().replace('-', '_');
            if (!s.equalsIgnoreCase(fill)) continue;
            button.setSelected(true);
            break;
        }
    }

    private ButtonGroup getFillRbGroup() {
        return ((DefaultButtonModel)this.myScaleRb.getModel()).getGroup();
    }

    private ButtonGroup getPlaceRbGroup() {
        return ((DefaultButtonModel)this.myCenterRb.getModel()).getGroup();
    }

    private ButtonGroup getTargetRbGroup() {
        return ((DefaultButtonModel)this.myEditorRb.getModel()).getGroup();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JSlider jSlider;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        JBRadioButton jBRadioButton3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 6, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBRadioButton jBRadioButton4 = new JBRadioButton();
        jBRadioButton4.setText("Frame background");
        jPanel3.add((Component)jBRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEditorRb = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("Editor background");
        jPanel3.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myPathField;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 5, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 3, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(13, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 4, 1, 2, 0, 3, 0, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Fill type:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScaleRb = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Scale");
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton5 = new JBRadioButton();
        jBRadioButton5.setText("Tile");
        jPanel4.add((Component)jBRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton6 = new JBRadioButton();
        jBRadioButton6.setText("Plain");
        jPanel4.add((Component)jBRadioButton6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Placement:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCenterRb = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Center");
        jPanel4.add((Component)jBRadioButton, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton7 = new JBRadioButton();
        jBRadioButton7.setText("Top-left");
        jPanel4.add((Component)jBRadioButton7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton8 = new JBRadioButton();
        jBRadioButton8.setText("Top-center");
        jPanel4.add((Component)jBRadioButton8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton9 = new JBRadioButton();
        jBRadioButton9.setText("Top-right");
        jPanel4.add((Component)jBRadioButton9, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton10 = new JBRadioButton();
        jBRadioButton10.setText("Bottom-left");
        jPanel4.add((Component)jBRadioButton10, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton11 = new JBRadioButton();
        jBRadioButton11.setText("Bottom-center");
        jPanel4.add((Component)jBRadioButton11, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBRadioButton jBRadioButton12 = new JBRadioButton();
        jBRadioButton12.setText("Bottom-right");
        jPanel4.add((Component)jBRadioButton12, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOpacitySlider = jSlider = new JSlider();
        jSlider.setPaintTicks(false);
        jPanel2.add((Component)jSlider, new GridConstraints(1, 1, 1, 4, 8, 1, 6, 0, null, null, null));
        this.myOpacitySpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 5, 1, 1, 8, 1, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Image:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Opacity:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(3, 2, 1, 4, 0, 1, 6, 1, null, null, null));
        jBLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel4.setLabelFor(jSpinner);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton6);
        buttonGroup.add((AbstractButton)jBRadioButton6);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton7);
        buttonGroup.add((AbstractButton)jBRadioButton8);
        buttonGroup.add((AbstractButton)jBRadioButton9);
        buttonGroup.add((AbstractButton)jBRadioButton10);
        buttonGroup.add((AbstractButton)jBRadioButton11);
        buttonGroup.add((AbstractButton)jBRadioButton12);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

