/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "built-in-server"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2) {
        Void void_;
        FileResolver resolver;
        void effectivePath;
        block14: {
            void $receiver$iv;
            PathInfo result2;
            Object it;
            Object moduleName;
            int index;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = path;
            if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((String)effectivePath.element), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = (String)effectivePath.element;
                String string2 = project2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
                if (!StringsKt.regionMatches((String)string, (int)0, (String)string2, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                    void startIndex$iv3;
                    void $receiver$iv2;
                    String string3 = (String)effectivePath.element;
                    boolean bl = false;
                    void v2 = $receiver$iv2;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = ((String)v2).substring((int)startIndex$iv3, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    moduleName = string4;
                    Module module2 = (Module)ActionsKt.runReadAction((Function0)new Function0<Module>(project2, (String)moduleName){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ String $moduleName;

                        @Nullable
                        public final Module invoke() {
                            return ModuleManager.getInstance((Project)this.$project).findModuleByName(this.$moduleName);
                        }
                        {
                            this.$project = project2;
                            this.$moduleName = string;
                            super(0);
                        }
                    });
                    if (module2 != null && !module2.isDisposed()) {
                        PathInfo pathInfo;
                        PathInfo pathInfo2;
                        FileResolver resolver2;
                        block12: {
                            void $receiver$iv3;
                            void startIndex$iv2;
                            void $receiver$iv4;
                            String startIndex$iv3 = (String)effectivePath.element;
                            int $i$f$substring = index + 1;
                            void var22_14 = effectivePath;
                            void v4 = $receiver$iv4;
                            if (v4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = ((String)v4).substring((int)startIndex$iv2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                            String string6 = string5;
                            var22_14.element = string6;
                            resolver2 = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                            Object[] objectArray = (Object[])RootProvider.values();
                            for (int i = 0; i < ((void)$receiver$iv3).length; ++i) {
                                void file$iv = $receiver$iv3[i];
                                it = (RootProvider)file$iv;
                                String string7 = (String)effectivePath.element;
                                ModuleRootManager moduleRootManager2 = moduleRootManager;
                                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                                PathInfo result$iv = DefaultWebServerRootsProviderKt.access$findByRelativePath(string7, ((RootProvider)((Object)it)).getRoots(moduleRootManager2), resolver2, (String)moduleName);
                                if (result$iv == null) continue;
                                pathInfo2 = result$iv;
                                break block12;
                            }
                            pathInfo2 = null;
                        }
                        if ((pathInfo = (PathInfo)pathInfo2) == null) {
                            pathInfo = result2 = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath.element, module2, resolver2);
                        }
                        if (result2 != null) {
                            return result2;
                        }
                    }
                }
            }
            resolver = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
            moduleName = (Object[])RootProvider.values();
            for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                Object v12;
                block13: {
                    void $receiver$iv5;
                    void file$iv = $receiver$iv[i];
                    RootProvider rootProvider = (RootProvider)file$iv;
                    result2 = (PathInfo)ActionsKt.runReadAction((Function0)new Function0<Module[]>(project2, path, resolver){
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ String $path$inlined;
                        final /* synthetic */ FileResolver $resolver$inlined;

                        public final Module[] invoke() {
                            return ModuleManager.getInstance((Project)this.$project$inlined).getModules();
                        }
                        {
                            this.$project$inlined = project2;
                            this.$path$inlined = string;
                            this.$resolver$inlined = fileResolver;
                            super(0);
                        }
                    });
                    for (int j = 0; j < ((void)$receiver$iv5).length; ++j) {
                        Object result$iv;
                        void file$iv2 = $receiver$iv5[j];
                        Module module3 = (Module)file$iv2;
                        if (!module3.isDisposed()) {
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                            PathInfo pathInfo = DefaultWebServerRootsProviderKt.access$findByRelativePath(path, rootProvider.getRoots(moduleRootManager), resolver, null);
                            if (pathInfo != null) {
                                void $receiver$iv6;
                                it = pathInfo;
                                PathInfo it2 = (PathInfo)$receiver$iv6;
                                it2.setModuleName(DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(project2, module3));
                                return it2;
                            }
                        }
                        if ((result$iv = null) == null) continue;
                        v12 = result$iv;
                        break block13;
                    }
                    v12 = null;
                }
                Void result$iv = v12;
                if (result$iv == null) continue;
                void_ = result$iv;
                break block14;
            }
            void_ = null;
        }
        Void void_2 = void_;
        return void_2 != null ? (PathInfo)void_2 : DefaultWebServerRootsProviderKt.access$findInLibraries(project2, (String)effectivePath.element, resolver);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return (PathInfo)ActionsKt.runReadAction((Function0)new Function0<PathInfo>(project2, file2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final PathInfo invoke() {
                PathInfo pathInfo;
                DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.$project);
                DirectoryInfo info = directoryIndex.getInfoForFile(this.$file);
                if (!info.isExcluded() && !info.isInProject()) {
                    pathInfo = Intrinsics.areEqual((Object)this.$file.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar(this.$file, this.$project) : (PathInfo)null;
                } else {
                    boolean isLibrary;
                    boolean isRootNameOptionalInPath;
                    VirtualFile root = info.getSourceRoot();
                    if (root == null) {
                        isRootNameOptionalInPath = false;
                        root = info.getContentRoot();
                        if (root == null) {
                            Unit unit;
                            root = info.getLibraryClassRoot();
                            isLibrary = true;
                            boolean bl = root != null;
                            if (_Assertions.ENABLED) {
                                void value$iv;
                                if (value$iv == false) {
                                    String string = this.$file.getPresentableUrl();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                                    String message$iv = string;
                                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                                }
                                unit = Unit.INSTANCE;
                            } else {
                                unit = Unit.INSTANCE;
                            }
                        } else {
                            isLibrary = false;
                        }
                    } else {
                        isLibrary = info.isInLibrarySource();
                        isRootNameOptionalInPath = !isLibrary;
                    }
                    Module module2 = info.getModule();
                    if (isLibrary && module2 == null) {
                        for (OrderEntry entry : directoryIndex.getOrderEntries(info)) {
                            if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                            module2 = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                            break;
                        }
                    }
                    Path path = null;
                    VirtualFile virtualFile = root;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
                    pathInfo = new PathInfo(path, this.$file, virtualFile, DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(this.$project, module2), isLibrary, isRootNameOptionalInPath);
                }
                return pathInfo;
            }
            {
                this.$project = project2;
                this.$file = virtualFile;
                super(0);
            }
        });
    }
}

