/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0003"}, d2={"EMPTY_PATH_RESOLVER", "Lorg/jetbrains/builtInWebServer/FileResolver;", "RELATIVE_PATH_RESOLVER", "built-in-server"})
public final class WebServerPathToFileManagerKt {
    private static final FileResolver RELATIVE_PATH_RESOLVER = new FileResolver(){

        @Nullable
        public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            if (root.isInLocalFileSystem() && Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                Path file2 = Paths.get(root.getPath(), path);
                if (PathKt.exists(file2)) {
                    return new PathInfo(file2, (VirtualFile)null, root, moduleName, isLibrary, false, 32, null);
                }
                return null;
            }
            VirtualFile virtualFile = root.findFileByRelativePath(path);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file3 = virtualFile;
            return new PathInfo((Path)null, file3, root, moduleName, isLibrary, false, 32, null);
        }
    };
    private static final FileResolver EMPTY_PATH_RESOLVER = new FileResolver(){

        @Nullable
        public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file2 = virtualFile;
            return new PathInfo((Path)null, file2, root, moduleName, isLibrary, false, 32, null);
        }
    };

    @NotNull
    public static final /* synthetic */ FileResolver access$getEMPTY_PATH_RESOLVER$p() {
        return EMPTY_PATH_RESOLVER;
    }

    @NotNull
    public static final /* synthetic */ FileResolver access$getRELATIVE_PATH_RESOLVER$p() {
        return RELATIVE_PATH_RESOLVER;
    }
}

