/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.MultiVmDebugProcess;
import org.jetbrains.debugger.RunningThreadExecutionStackView;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextView;
import org.jetbrains.debugger.SuspendContextViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u0016J+\u0010\u0017\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00160\u00160\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u0015\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8TX\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/jetbrains/debugger/SuspendContextView;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "debugProcess", "Lorg/jetbrains/debugger/MultiVmDebugProcess;", "activeStack", "Lorg/jetbrains/debugger/ExecutionStackView;", "(Lorg/jetbrains/debugger/MultiVmDebugProcess;Lorg/jetbrains/debugger/ExecutionStackView;)V", "getActiveStack", "()Lorg/jetbrains/debugger/ExecutionStackView;", "getDebugProcess", "()Lorg/jetbrains/debugger/MultiVmDebugProcess;", "stacks", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "getStacks", "()[Lcom/intellij/xdebugger/frame/XExecutionStack;", "stacks$delegate", "Lkotlin/Lazy;", "createStackView", "context", "Lorg/jetbrains/debugger/SuspendContext;", "displayName", "", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "getExecutionStacks", "script-debugger-ui"})
public abstract class SuspendContextView
extends XSuspendContext {
    @NotNull
    private final Lazy<XExecutionStack[]> stacks$delegate;
    @NotNull
    private final MultiVmDebugProcess debugProcess;
    @NotNull
    private final ExecutionStackView activeStack;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected XExecutionStack[] getStacks() {
        void $receiver$iv;
        Lazy<XExecutionStack[]> lazy = this.stacks$delegate;
        SuspendContextView suspendContextView = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (XExecutionStack[])$receiver$iv.getValue();
    }

    private final XExecutionStack createStackView(SuspendContext<?> context, String displayName) {
        return context == null ? (XExecutionStack)new RunningThreadExecutionStackView(displayName) : (XExecutionStack)new ExecutionStackView(context, this.activeStack.getViewSupport$script_debugger_ui(), null, null, displayName);
    }

    @NotNull
    public ExecutionStackView getActiveExecutionStack() {
        return this.activeStack;
    }

    @NotNull
    public XExecutionStack[] getExecutionStacks() {
        return this.getStacks();
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        CallFrameView callFrameView = this.activeStack.getTopFrame();
        if (callFrameView == null) {
            return PromiseKt.rejectedPromise("Top frame is null");
        }
        CallFrameView frame = callFrameView;
        Promise<String> promise2 = this.evaluateExpression(frame.getCallFrame().getEvaluateContext(), expression);
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"evaluateExpression(frame\u2026luateContext, expression)");
        return promise2;
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext2, String expression) {
        return EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, expression, null, false, 6, null).thenAsync((AsyncFunction)evaluateExpression.1.INSTANCE);
    }

    @NotNull
    protected final MultiVmDebugProcess getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    protected final ExecutionStackView getActiveStack() {
        return this.activeStack;
    }

    public SuspendContextView(@NotNull MultiVmDebugProcess debugProcess, @NotNull ExecutionStackView activeStack) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)((Object)activeStack), (String)"activeStack");
        this.debugProcess = debugProcess;
        this.activeStack = activeStack;
        this.stacks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XExecutionStack[]>(this){
            final /* synthetic */ SuspendContextView this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final XExecutionStack[] invoke() {
                XExecutionStack[] xExecutionStackArray;
                List<VmConnection<?>> childConnections = this.this$0.getDebugProcess().getChildConnections();
                Collection $receiver$iv = childConnections;
                if (!$receiver$iv.isEmpty()) {
                    void $receiver$iv$iv;
                    Collection $receiver$iv2;
                    ArrayList<XExecutionStack> list = new ArrayList<XExecutionStack>(1 + childConnections.size());
                    Vm mainVm = this.this$0.getDebugProcess().getMainVm();
                    if (Intrinsics.areEqual((Object)this.this$0.getActiveStack().getSuspendContext().getVm(), (Object)mainVm)) {
                        list.add(this.this$0.getActiveStack());
                    } else {
                        Object object = mainVm;
                        list.add(SuspendContextView.access$createStackView(this.this$0, object != null && (object = object.getSuspendContextManager()) != null ? object.getContext() : null, SuspendContextViewKt.MAIN_LOOP_NAME));
                    }
                    Iterable iterable = childConnections;
                    void var5_5 = $receiver$iv2;
                    for (T element$iv$iv : $receiver$iv$iv) {
                        Boolean bl;
                        XExecutionStack xExecutionStack;
                        T element$iv = element$iv$iv;
                        VmConnection it = (VmConnection)element$iv;
                        if (it.getVm() != null) {
                            XExecutionStack xExecutionStack2;
                            void $receiver$iv3;
                            Vm it2 = (Vm)$receiver$iv3;
                            SuspendContext<? extends CallFrame> context = it2.getSuspendContextManager().getContext();
                            if (Intrinsics.areEqual(context, this.this$0.getActiveStack().getSuspendContext())) {
                                xExecutionStack2 = this.this$0.getActiveStack();
                            } else {
                                String displayName;
                                if (it2.getName() == null) {
                                    throw (Throwable)new IllegalStateException("Name must be not null for child VM");
                                }
                                xExecutionStack2 = SuspendContextView.access$createStackView(this.this$0, context, displayName);
                            }
                            xExecutionStack = xExecutionStack2;
                        } else {
                            xExecutionStack = null;
                        }
                        if (xExecutionStack != null) {
                            void $receiver$iv$iv2;
                            XExecutionStack xExecutionStack3 = xExecutionStack;
                            void it$iv = $receiver$iv$iv2;
                            bl = ((Collection)list).add(it$iv);
                            continue;
                        }
                        bl = null;
                    }
                    Collection cfr_ignored_0 = (Collection)list;
                    $receiver$iv2 = list;
                    Collection thisCollection$iv = $receiver$iv2;
                    XExecutionStack[] xExecutionStackArray2 = thisCollection$iv.toArray(new XExecutionStack[thisCollection$iv.size()]);
                    if (xExecutionStackArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    xExecutionStackArray = (XExecutionStack[])((Object[])xExecutionStackArray2);
                } else {
                    ExecutionStackView[] elements$iv = new ExecutionStackView[]{this.this$0.getActiveStack()};
                    xExecutionStackArray = (XExecutionStack[])((Object[])elements$iv);
                }
                return xExecutionStackArray;
            }
            {
                this.this$0 = suspendContextView;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SuspendContextView.class), "stacks", "getStacks()[Lcom/intellij/xdebugger/frame/XExecutionStack;"))};
    }

    @NotNull
    public static final /* synthetic */ XExecutionStack access$createStackView(SuspendContextView $this, @Nullable SuspendContext context, @NotNull String displayName) {
        return $this.createStackView(context, displayName);
    }
}

