/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public final class ChannelRegistrar
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

    public boolean isEmpty() {
        return this.openChannels.isEmpty();
    }

    public void add(@NotNull Channel serverChannel) {
        if (serverChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/io/ChannelRegistrar", "add"));
        }
        assert (serverChannel instanceof ServerChannel);
        this.openChannels.add((Object)serverChannel);
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        this.openChannels.add((Object)context.channel());
        super.channelActive(context);
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> close(boolean shutdownEventLoopGroup) {
        io.netty.util.concurrent.Future result2;
        EventLoopGroup eventLoopGroup = null;
        if (shutdownEventLoopGroup) {
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
        }
        try {
            ChannelGroupFuture groupFuture = this.openChannels.close();
            groupFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS);
            result2 = groupFuture;
        }
        finally {
            if (eventLoopGroup != null) {
                result2 = eventLoopGroup.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
            }
        }
        io.netty.util.concurrent.Future future2 = result2;
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelRegistrar", "close"));
        }
        return future2;
    }
}

