/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.Sanselan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.DelegatingHttpRequestHandlerKt;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.Responses;

@ChannelHandler.Sharable
@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandler;", "Lorg/jetbrains/io/DelegatingHttpRequestHandlerBase;", "()V", "exceptionCaught", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "process", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "platform-impl"})
public final class DelegatingHttpRequestHandler
extends DelegatingHttpRequestHandlerBase {
    @Override
    protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Function1<HttpRequestHandler, Boolean> checkAndProcess$ = new Function1<HttpRequestHandler, Boolean>(request, urlDecoder, context){
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ QueryStringDecoder $urlDecoder;
            final /* synthetic */ ChannelHandlerContext $context;

            public final boolean invoke(HttpRequestHandler $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return $receiver.isSupported(this.$request) && !NettyKt.isWriteFromBrowserWithoutOrigin((HttpRequest)this.$request) && $receiver.isAccessible((HttpRequest)this.$request) && $receiver.process(this.$urlDecoder, this.$request, this.$context);
            }
            {
                this.$request = fullHttpRequest;
                this.$urlDecoder = queryStringDecoder;
                this.$context = channelHandlerContext;
                super(1);
            }
        };
        Attribute prevHandlerAttribute = context.attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p());
        HttpRequestHandler connectedHandler = (HttpRequestHandler)prevHandlerAttribute.get();
        if (connectedHandler != null) {
            if (checkAndProcess$.invoke(connectedHandler)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        HttpRequestHandler[] httpRequestHandlerArray = (HttpRequestHandler[])HttpRequestHandler.EP_NAME.getExtensions();
        for (int i = 0; i < httpRequestHandlerArray.length; ++i) {
            HttpRequestHandler handler2 = httpRequestHandlerArray[i];
            try {
                if (!checkAndProcess$.invoke(handler2)) continue;
                prevHandlerAttribute.set((Object)handler2);
                return true;
            }
            catch (Throwable e) {
                Logger.getInstance(BuiltInServer.class).error(e);
            }
        }
        if (Intrinsics.areEqual((Object)urlDecoder.path(), (Object)"/favicon.ico") && (icon = IconLoader.findIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl())) != null) {
            BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            byte[] icoBytes = Sanselan.writeImageToBytes((BufferedImage)image, (ImageFormat)ImageFormat.IMAGE_FORMAT_ICO, (Map)null);
            String string = urlDecoder.path();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"urlDecoder.path()");
            HttpResponse httpResponse = Responses.addNoCache((HttpResponse)Responses.response(FileResponses.INSTANCE.getContentType(string), Unpooled.wrappedBuffer((byte[])icoBytes)));
            Channel channel = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
            Responses.send$default(httpResponse, channel, (HttpRequest)request, null, 4, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        try {
            context.attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p()).remove();
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

