/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "built-in-server"})
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(FastCgiService.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        try {
            if (channel.isActive()) {
                Responses.send$default(HttpResponseStatus.BAD_GATEWAY, channel, null, null, extraHeaders, 6, null);
            }
        }
        catch (Throwable e) {
            NettyUtil.log(e, LOG);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            void $receiver$iv;
            byte b22;
            builder.setLength(0);
            String key2 = null;
            boolean valueExpected = true;
            while ((b22 = buffer.readByte()) >= 0 && (char)b22 != '\n') {
                if ((char)b22 == '\r') continue;
                if (valueExpected && (char)b22 == ':') {
                    valueExpected = false;
                    key2 = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace(buffer);
                    continue;
                }
                builder.append((char)b22);
            }
            if (builder.length() == 0) {
                return;
            }
            CharSequence b22 = key2;
            if ($receiver$iv == null || $receiver$iv.length() == 0) continue;
            String string = key2;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith((String)string, (String)"http", (boolean)true) || StringsKt.startsWith((String)key2, (String)"X-Accel-", (boolean)true)) continue;
            String value = builder.toString();
            if (StringsKt.equals((String)key2, (String)"status", (boolean)true)) {
                String string2;
                void startIndex$iv;
                void $receiver$iv2;
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                String string3 = value;
                boolean bl = false;
                HttpResponse httpResponse = response;
                void v1 = $receiver$iv2;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)v1).substring((int)startIndex$iv, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                httpResponse.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(string2)));
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key2, (String)"HTTP", (boolean)false, (int)2, null)) continue;
            response.headers().add(key2, (Object)value);
        }
    }

    public static final /* synthetic */ void access$sendBadGateway(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        FastCgiServiceKt.sendBadGateway(channel, extraHeaders);
    }

    public static final /* synthetic */ void access$parseHeaders(@NotNull HttpResponse response, @NotNull ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }
}

