/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtilEx;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015JG\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u001dJQ\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001f\u001a\u00020\u001b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00172\f\b\u0002\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010 J+\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J0\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00072\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\b2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u00101\u001a\u0004\u0018\u000102J3\u00103\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u00104J;\u00103\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u00105J \u00106\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)J\"\u00107\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0017J7\u00108\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00172\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "clientManager", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "(Lorg/jetbrains/io/jsonRpc/ClientManager;)V", "domains", "Lgnu/trove/THashMap;", "", "Lcom/intellij/openapi/util/NotNullLazyValue;", "messageIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "call", "Lorg/jetbrains/concurrency/Promise;", "T", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "domain", "command", "params", "", "", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "doEncodeMessage", "Lio/netty/buffer/ByteBuf;", "byteBufAllocator", "Lio/netty/buffer/ByteBufAllocator;", "id", "", "rawData", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "encodeMessage", "messageId", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Lio/netty/buffer/ByteBuf;", "encodeParameters", "", "buffer", "_sb", "Ljava/lang/StringBuilder;", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;Ljava/lang/StringBuilder;)V", "messageReceived", "message", "", "processClientError", "error", "registerDomain", "name", "commands", "overridable", "", "disposable", "Lcom/intellij/openapi/Disposable;", "send", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "sendErrorResponse", "sendResponse", "sendWithRawPart", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Z", "built-in-server"})
public final class JsonRpcServer
implements MessageServer {
    private final AtomicInteger messageIdCounter;
    private final THashMap<String, NotNullLazyValue<?>> domains;
    private final ClientManager clientManager;

    public final void registerDomain(@NotNull String name, @NotNull NotNullLazyValue<?> commands, boolean overridable, @Nullable Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        if (this.domains.containsKey((Object)name)) {
            if (overridable) {
                return;
            }
            throw (Throwable)new IllegalArgumentException(name + " is already registered");
        }
        this.domains.put((Object)name, commands);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(this, name){
                final /* synthetic */ JsonRpcServer this$0;
                final /* synthetic */ String $name;

                public final void dispose() {
                    JsonRpcServer.access$getDomains$p(this.this$0).remove((Object)this.$name);
                }
                {
                    this.this$0 = jsonRpcServer;
                    this.$name = string;
                }
            });
        }
    }

    public static /* bridge */ /* synthetic */ void registerDomain$default(JsonRpcServer jsonRpcServer, String string, NotNullLazyValue notNullLazyValue, boolean bl, Disposable disposable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerDomain");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            disposable = null;
        }
        jsonRpcServer.registerDomain(string, notNullLazyValue, bl, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message) {
        Method[] methods;
        Object[] parameters;
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        reader.beginArray();
        int messageId = Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.NUMBER) ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise2 = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise2 == null) {
                    JsonRpcServerKt.access$getLOG$p().error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise2.setResult(JsonUtil.nextAny(reader));
            } else {
                AsyncPromise asyncPromise = promise2;
                if (asyncPromise == null) {
                    Intrinsics.throwNpe();
                }
                asyncPromise.setError("error");
            }
            return;
        }
        NotNullLazyValue domainHolder = (NotNullLazyValue)this.domains.get((Object)domainName);
        if (domainHolder == null) {
            this.processClientError(client, "Cannot find domain " + domainName, messageId);
            return;
        }
        Object domain = domainHolder.getValue();
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId, message);
            return;
        }
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody(reader, (List)list);
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)((Collection)list));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.toObjectArray(list)");
            parameters = objectArray;
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"ArrayUtilRt.EMPTY_OBJECT_ARRAY");
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        boolean isStatic = domain instanceof Class;
        if (isStatic) {
            Object object = domain;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            Method[] methodArray = ((Class)object).getDeclaredMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"(domain as Class<*>).declaredMethods");
            methods = methodArray;
        } else {
            Method[] methodArray = domain.getClass().getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"domain.javaClass.methods");
            methods = methodArray;
        }
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)command)) continue;
            method.setAccessible(true);
            Object result2 = method.invoke(isStatic ? null : domain, Arrays.copyOf(parameters, parameters.length));
            if (messageId != -1) {
                if (result2 instanceof ByteBuf) {
                    ByteBuf byteBuf = (ByteBuf)result2;
                    try {
                        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, (ByteBuf)result2, null, 44, null));
                    }
                    catch (Exception e$iv) {
                        try {
                            void $receiver$iv;
                            $receiver$iv.release();
                        }
                        finally {
                            throw (Throwable)e$iv;
                        }
                    }
                } else {
                    Object[] objectArray;
                    Client client2 = client;
                    JsonRpcServer jsonRpcServer = this;
                    ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                    ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                    int n = messageId;
                    String string = null;
                    String string2 = null;
                    ByteBuf byteBuf = null;
                    if (result2 == null) {
                        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
                    } else {
                        void elements$iv;
                        Object[] $receiver$iv = new Object[]{result2};
                        ByteBuf byteBuf2 = byteBuf;
                        String string3 = string2;
                        String string4 = string;
                        int n2 = n;
                        ByteBufAllocator byteBufAllocator3 = byteBufAllocator2;
                        JsonRpcServer jsonRpcServer2 = jsonRpcServer;
                        Client client3 = client2;
                        Object[] objectArray2 = (Object[])elements$iv;
                        client2 = client3;
                        jsonRpcServer = jsonRpcServer2;
                        byteBufAllocator2 = byteBufAllocator3;
                        n = n2;
                        string = string4;
                        string2 = string3;
                        byteBuf = byteBuf2;
                        objectArray = objectArray2;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"if (result == null) Arra\u2026RRAY else arrayOf(result)");
                    client2.send(JsonRpcServer.encodeMessage$default(jsonRpcServer, byteBufAllocator2, n, string, string2, byteBuf, objectArray, 28, null));
                }
            }
            return;
        }
        this.processClientError(client, "Cannot find method " + domain + "." + command, messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClientError(Client client, String error, int messageId) {
        try {
            JsonRpcServerKt.access$getLOG$p().error(error);
        }
        finally {
            if (messageId != -1) {
                this.sendErrorResponse(client, messageId, error);
            }
        }
    }

    public final void sendResponse(@NotNull Client client, int messageId, @Nullable ByteBuf rawData) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, rawData, null, 44, null));
    }

    public static /* bridge */ /* synthetic */ void sendResponse$default(JsonRpcServer jsonRpcServer, Client client, int n, ByteBuf byteBuf, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendResponse");
        }
        if ((n2 & 4) != 0) {
            byteBuf = null;
        }
        jsonRpcServer.sendResponse(client, n, byteBuf);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendErrorResponse(@NotNull Client client, int messageId, @Nullable CharSequence message) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        CharSequence[] charSequenceArray = new CharSequence[]{message};
        ByteBuf byteBuf = null;
        String string = null;
        String string2 = "e";
        int n = messageId;
        ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
        JsonRpcServer jsonRpcServer = this;
        Client client2 = client;
        Object[] objectArray = (Object[])elements$iv;
        client2.send(JsonRpcServer.encodeMessage$default(jsonRpcServer, byteBufAllocator2, n, string2, string, byteBuf, objectArray, 24, null));
    }

    public final boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @NotNull ByteBuf rawData, @NotNull Object[] params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)rawData, (String)"rawData");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        return client.send(this.encodeMessage(byteBufAllocator, -1, domain, command, rawData, params)).cause() == null;
    }

    public final void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, -1, domain, command, null, params, 16, null));
    }

    @NotNull
    public final <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        int messageId = this.messageIdCounter.getAndIncrement();
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        ByteBuf message = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
        AsyncPromise asyncPromise = client.send(messageId, message);
        if (asyncPromise == null) {
            Intrinsics.throwNpe();
        }
        return (Promise)asyncPromise;
    }

    public final void send(@NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (this.clientManager.hasClients()) {
            int messageId = -1;
            ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"ByteBufAllocator.DEFAULT");
            ByteBuf message = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
            ClientManager.send$default(this.clientManager, messageId, message, null, 4, null);
        }
    }

    private final ByteBuf encodeMessage(ByteBufAllocator byteBufAllocator, int messageId, String domain, String command, ByteBuf rawData, Object[] params) {
        ByteBuf buffer = this.doEncodeMessage(byteBufAllocator, messageId, domain, command, params, rawData);
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("OUT " + buffer.toString(Charsets.UTF_8));
        }
        return buffer;
    }

    static /* bridge */ /* synthetic */ ByteBuf encodeMessage$default(JsonRpcServer jsonRpcServer, ByteBufAllocator byteBufAllocator, int n, String string, String string2, ByteBuf byteBuf, Object[] objectArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeMessage");
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            byteBuf = null;
        }
        if ((n2 & 0x20) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return jsonRpcServer.encodeMessage(byteBufAllocator, n, string, string2, byteBuf, objectArray);
    }

    private final ByteBuf doEncodeMessage(ByteBufAllocator byteBufAllocator, int id, String domain, String command, Object[] params, ByteBuf rawData) {
        Object[] $receiver$iv$iv;
        Object[] $receiver$iv;
        ByteBuf buffer = byteBufAllocator.ioBuffer();
        JsonRpcServerKt.access$writeByte(buffer, '[');
        StringBuilder sb = null;
        if (id != -1) {
            sb = new StringBuilder();
            CharSequence charSequence = sb.append(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"sb.append(id)");
            JsonRpcServerKt.access$writeAscii(buffer, charSequence);
            sb.setLength(0);
        }
        if (domain != null) {
            if (id != -1) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            }
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(JsonRpcServerKt.access$writeByte(buffer, '\"'), domain), '\"');
            if (command != null) {
                JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeByte(buffer, ','), '\"'), command), '\"');
            }
        }
        ByteBuf effectiveBuffer = buffer;
        Object[] objectArray = params;
        void var11_11 = $receiver$iv;
        if (!($receiver$iv$iv.length == 0) || rawData != null) {
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeByte(buffer, ','), '[');
            ByteBuf byteBuf = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
            this.encodeParameters(byteBuf, params, sb);
            if (rawData != null) {
                $receiver$iv = params;
                $receiver$iv$iv = $receiver$iv;
                if (!($receiver$iv$iv.length == 0)) {
                    JsonRpcServerKt.access$writeByte(buffer, ',');
                }
                effectiveBuffer = (ByteBuf)byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
                buffer = byteBufAllocator.ioBuffer();
            }
            JsonRpcServerKt.access$writeByte(buffer, ']');
        }
        JsonRpcServerKt.access$writeByte(buffer, ']');
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return JsonRpcServerKt.access$addBuffer(effectiveBuffer, byteBuf);
    }

    private final void encodeParameters(ByteBuf buffer, Object[] params, StringBuilder _sb) {
        StringBuilder sb = _sb;
        JsonWriter writer = null;
        boolean hasPrev = false;
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (hasPrev) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            } else {
                hasPrev = true;
            }
            if (param instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, buffer);
                continue;
            }
            if (param == null) {
                JsonRpcServerKt.access$writeAscii(buffer, "null");
                continue;
            }
            if (param instanceof Boolean) {
                JsonRpcServerKt.access$writeAscii(buffer, param.toString());
                continue;
            }
            if (param instanceof Number) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (param instanceof Integer) {
                    sb.append(((Number)param).intValue());
                } else if (param instanceof Long) {
                    sb.append(((Number)param).longValue());
                } else if (param instanceof Float) {
                    sb.append(((Number)param).floatValue());
                } else if (param instanceof Double) {
                    sb.append(((Number)param).doubleValue());
                } else {
                    sb.append(param.toString());
                }
                JsonRpcServerKt.access$writeAscii(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (param instanceof Consumer) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                Object object = param;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Consumer<java.lang.StringBuilder>");
                }
                ((Consumer)object).consume((Object)sb);
                ByteBufUtilEx.writeUtf8(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter((Writer)new ByteBufUtf8Writer(buffer));
            }
            TypeAdapter typeAdapter = JsonRpcServerKt.access$getGson$p().getAdapter(param.getClass());
            if (typeAdapter == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any>");
            }
            typeAdapter.write(writer, param);
        }
    }

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        Intrinsics.checkParameterIsNotNull((Object)clientManager, (String)"clientManager");
        this.clientManager = clientManager;
        this.messageIdCounter = new AtomicInteger();
        this.domains = new THashMap();
    }

    @NotNull
    public static final /* synthetic */ THashMap access$getDomains$p(JsonRpcServer $this) {
        return $this.domains;
    }
}

