/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.descriptor;

import java.util.Optional;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.JUnit4TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.RunnerRequest;
import org.junit.gen5.engine.support.descriptor.JavaSource;
import org.junit.runner.Request;
import org.junit.runner.Runner;

@API(value=API.Usage.Internal)
public class RunnerTestDescriptor
extends JUnit4TestDescriptor {
    public static final char SEPARATOR = ':';
    private final Runner runner;
    private final Class<?> testClass;

    public RunnerTestDescriptor(TestDescriptor parent, Class<?> testClass, Runner runner) {
        super(parent, ':', testClass.getName(), runner.getDescription(), Optional.of(new JavaSource(testClass)));
        this.testClass = testClass;
        this.runner = runner;
    }

    public Runner getRunner() {
        return this.runner;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public String getName() {
        return this.testClass.getName();
    }

    @Override
    public String getDisplayName() {
        return this.testClass.getName();
    }

    public Request toRequest() {
        return new RunnerRequest(this.runner);
    }
}

