/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.commons.util;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ClasspathScanner;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Preconditions.notNull(clazz, "class must not be null");
        Preconditions.notNull(args, "none of the arguments may be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            Constructor<T> constructor = ReflectionUtils.makeAccessible(clazz.getDeclaredConstructor(parameterTypes));
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Preconditions.notNull(method, "method must not be null");
        Preconditions.condition(target != null || ReflectionUtils.isStatic(method), () -> String.format("Cannot invoke non-static method [%s] on a null target.", method.toGenericString()));
        try {
            return ReflectionUtils.makeAccessible(method).invoke(target, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.loadClass(name, ReflectionUtils.getDefaultClassLoader());
    }

    public static Optional<Class<?>> loadClass(String name, ClassLoader classLoader) {
        Preconditions.notBlank(name, "class name must not be null or empty");
        Preconditions.notNull(classLoader, "ClassLoader must not be null");
        try {
            return Optional.of(classLoader.loadClass(name.trim()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Optional<Method> loadMethod(String fullyQualifiedMethodName) {
        Preconditions.notBlank(fullyQualifiedMethodName, "full method name must not be null or empty");
        Optional<Method> testMethodOptional = Optional.empty();
        int hashPosition = fullyQualifiedMethodName.lastIndexOf(35);
        if (hashPosition >= 0 && hashPosition < fullyQualifiedMethodName.length()) {
            String className = fullyQualifiedMethodName.substring(0, hashPosition);
            String methodName = fullyQualifiedMethodName.substring(hashPosition + 1);
            Optional<Class<?>> methodClassOptional = ReflectionUtils.loadClass(className);
            if (methodClassOptional.isPresent()) {
                try {
                    testMethodOptional = Optional.of(methodClassOptional.get().getDeclaredMethod(methodName, new Class[0]));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return testMethodOptional;
    }

    public static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(f -> f.getName().startsWith("this$")).findFirst().map(f -> {
            try {
                return ReflectionUtils.makeAccessible(f).get(inner);
            }
            catch (IllegalAccessException e) {
                return Optional.empty();
            }
        });
    }

    public static Optional<Object> getOuterInstance(Object inner, Class<?> targetType) {
        if (targetType.isInstance(inner)) {
            return Optional.of(inner);
        }
        Optional<Object> candidate = ReflectionUtils.getOuterInstance(inner);
        if (candidate.isPresent()) {
            return ReflectionUtils.getOuterInstance(candidate.get(), targetType);
        }
        return Optional.empty();
    }

    public static boolean isPackage(String packageName) {
        return new ClasspathScanner(ReflectionUtils::getDefaultClassLoader, ReflectionUtils::loadClass).isPackage(packageName);
    }

    public static Set<File> getAllClasspathRootDirectories() {
        String fullClassPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        return Arrays.stream(fullClassPath.split(separator)).filter(part -> !part.endsWith(".jar")).map(File::new).filter(File::isDirectory).collect(Collectors.toSet());
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(File root, Predicate<Class<?>> classTester) {
        return new ClasspathScanner(ReflectionUtils::getDefaultClassLoader, ReflectionUtils::loadClass).scanForClassesInClasspathRoot(root, classTester);
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classTester) {
        return new ClasspathScanner(ReflectionUtils::getDefaultClassLoader, ReflectionUtils::loadClass).scanForClassesInPackage(basePackageName, classTester);
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "predicate must not be null");
        return Arrays.stream(clazz.getDeclaredClasses()).filter(predicate).collect(Collectors.toList());
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Predicate<Method> nameAndParameterTypesMatch = method -> method.getName().equals(methodName) && Arrays.equals(method.getParameterTypes(), parameterTypes);
        List<Method> candidates = ReflectionUtils.findMethods(clazz, nameAndParameterTypesMatch);
        return !candidates.isEmpty() ? Optional.of(candidates.get(0)) : Optional.empty();
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.findMethods(clazz, predicate, MethodSortOrder.HierarchyDown);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "predicate must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        return ReflectionUtils.findAllMethodsInHierarchy(clazz, sortOrder).stream().filter(predicate).collect(Collectors.toList());
    }

    public static List<Method> findAllMethodsInHierarchy(Class<?> clazz, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        List<Method> localMethods = Arrays.asList(clazz.getDeclaredMethods());
        List superclassMethods = ReflectionUtils.getSuperclassMethods(clazz, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        List interfaceMethods = ReflectionUtils.getInterfaceMethods(clazz, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        ArrayList<Method> methods = new ArrayList<Method>();
        if (sortOrder == MethodSortOrder.HierarchyDown) {
            methods.addAll(superclassMethods);
            methods.addAll(interfaceMethods);
        }
        methods.addAll(localMethods);
        if (sortOrder == MethodSortOrder.HierarchyUp) {
            methods.addAll(interfaceMethods);
            methods.addAll(superclassMethods);
        }
        return methods;
    }

    public static <T> Optional<Object> readFieldValue(Class<T> clazz, String fieldName, T instance) {
        try {
            Field field = ReflectionUtils.makeAccessible(clazz.getDeclaredField(fieldName));
            return Optional.ofNullable(field.get(instance));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return Optional.empty();
        }
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        ArrayList<Method> allInterfaceMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List localMethods = Arrays.stream(ifc.getDeclaredMethods()).filter(Method::isDefault).collect(Collectors.toList());
            List subInterfaceMethods = ReflectionUtils.getInterfaceMethods(ifc, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
            if (sortOrder == MethodSortOrder.HierarchyDown) {
                allInterfaceMethods.addAll(subInterfaceMethods);
            }
            allInterfaceMethods.addAll(localMethods);
            if (sortOrder != MethodSortOrder.HierarchyUp) continue;
            allInterfaceMethods.addAll(subInterfaceMethods);
        }
        return allInterfaceMethods;
    }

    private static List<Method> getSuperclassMethods(Class<?> clazz, MethodSortOrder sortOrder) {
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtils.findAllMethodsInHierarchy(clazz.getSuperclass(), sortOrder);
        }
        return Collections.emptyList();
    }

    private static boolean isMethodShadowedByLocalMethods(Method method, List<Method> localMethods) {
        return localMethods.stream().anyMatch(local -> ReflectionUtils.isMethodShadowedBy(method, local));
    }

    private static boolean isMethodShadowedBy(Method upper, Method lower) {
        Class<?>[] upperParameterTypes;
        if (!lower.getName().equals(upper.getName())) {
            return false;
        }
        Class<?>[] lowerParameterTypes = lower.getParameterTypes();
        if (lowerParameterTypes.length != (upperParameterTypes = upper.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < lowerParameterTypes.length; ++i) {
            if (lowerParameterTypes[i].equals(upperParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    private static Throwable getUnderlyingCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ReflectionUtils.getUnderlyingCause(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }

    public static Set<Class<?>> getAllAssignmentCompatibleClasses(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        ReflectionUtils.getAllAssignmentCompatibleClasses(clazz, result);
        return result;
    }

    private static void getAllAssignmentCompatibleClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (result.contains(interfaceClass)) continue;
                ReflectionUtils.getAllAssignmentCompatibleClasses(interfaceClass, result);
            }
        }
    }

    public static enum MethodSortOrder {
        HierarchyDown,
        HierarchyUp;

    }
}

