/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.artifacts;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactProperties;
import com.intellij.lang.ant.config.impl.artifacts.SinglePropertyContainer;
import com.intellij.lang.ant.config.impl.configuration.UIPropertyBinding;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.config.ListProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class AntArtifactPropertiesEditor
extends ArtifactPropertiesEditor {
    private static final ListProperty<BuildFileProperty> ANT_PROPERTIES = ListProperty.create((String)"ant-properties");
    private static final ColumnInfo<BuildFileProperty, String> NAME_COLUMN = new ColumnInfo<BuildFileProperty, String>(AntBundle.message("edit.ant.properties.name.column.name", new Object[0])){

        public String valueOf(BuildFileProperty buildFileProperty) {
            return buildFileProperty.getPropertyName();
        }

        public boolean isCellEditable(BuildFileProperty buildFileProperty) {
            return USER_PROPERTY_CONDITION.value((Object)buildFileProperty);
        }

        public void setValue(BuildFileProperty buildFileProperty, String name) {
            buildFileProperty.setPropertyName(name);
        }
    };
    private static final ColumnInfo<BuildFileProperty, String> VALUE_COLUMN = new ColumnInfo<BuildFileProperty, String>(AntBundle.message("edit.ant.properties.value.column.name", new Object[0])){

        public boolean isCellEditable(BuildFileProperty buildFileProperty) {
            return USER_PROPERTY_CONDITION.value((Object)buildFileProperty);
        }

        public String valueOf(BuildFileProperty buildFileProperty) {
            return buildFileProperty.getPropertyValue();
        }

        public void setValue(BuildFileProperty buildFileProperty, String value) {
            buildFileProperty.setPropertyValue(value);
        }
    };
    private static final ColumnInfo[] PROPERTY_COLUMNS = new ColumnInfo[]{NAME_COLUMN, VALUE_COLUMN};
    private static final Condition<BuildFileProperty> USER_PROPERTY_CONDITION = property -> !AntArtifactProperties.isPredefinedProperty(property.getPropertyName());
    private final AntArtifactProperties myProperties;
    private final ArtifactEditorContext myContext;
    private final AntConfigurationListener myAntConfigurationListener;
    private JPanel myMainPanel;
    private JCheckBox myRunTargetCheckBox;
    private FixedSizeButton mySelectTargetButton;
    private JBTable myPropertiesTable;
    private JPanel myPropertiesPanel;
    private AntBuildTarget myTarget;
    private final boolean myPostProcessing;
    private UIPropertyBinding.TableListBinding<BuildFileProperty> myBinding;
    protected SinglePropertyContainer<ListProperty> myContainer;

    public AntArtifactPropertiesEditor(AntArtifactProperties properties, ArtifactEditorContext context, boolean postProcessing) {
        this.myProperties = properties;
        this.myContext = context;
        this.myPostProcessing = postProcessing;
        this.$$$setupUI$$$();
        this.mySelectTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntArtifactPropertiesEditor.this.selectTarget();
            }
        });
        this.myRunTargetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntArtifactPropertiesEditor.this.mySelectTargetButton.setEnabled(AntArtifactPropertiesEditor.this.myRunTargetCheckBox.isSelected());
                if (AntArtifactPropertiesEditor.this.myRunTargetCheckBox.isSelected() && AntArtifactPropertiesEditor.this.myTarget == null) {
                    AntArtifactPropertiesEditor.this.selectTarget();
                }
                AntArtifactPropertiesEditor.this.updatePanel();
            }
        });
        this.myPropertiesTable = new JBTable();
        UIPropertyBinding.Composite binding = new UIPropertyBinding.Composite();
        this.myBinding = binding.bindList((JTable)this.myPropertiesTable, PROPERTY_COLUMNS, ANT_PROPERTIES);
        this.myPropertiesPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myPropertiesTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableModel model = (ListTableModel)AntArtifactPropertiesEditor.this.myPropertiesTable.getModel();
                if (AntArtifactPropertiesEditor.this.myPropertiesTable.isEditing() && !AntArtifactPropertiesEditor.this.myPropertiesTable.getCellEditor().stopCellEditing()) {
                    return;
                }
                BuildFileProperty item = new BuildFileProperty();
                ArrayList<BuildFileProperty> items = new ArrayList<BuildFileProperty>(model.getItems());
                items.add(item);
                model.setItems(items);
                int newIndex = model.indexOf((Object)item);
                ListSelectionModel selectionModel = AntArtifactPropertiesEditor.this.myPropertiesTable.getSelectionModel();
                selectionModel.clearSelection();
                selectionModel.setSelectionInterval(newIndex, newIndex);
                ColumnInfo[] columns = model.getColumnInfos();
                for (int i = 0; i < columns.length; ++i) {
                    ColumnInfo column = columns[i];
                    if (!column.isCellEditable((Object)item)) continue;
                    AntArtifactPropertiesEditor.this.myPropertiesTable.requestFocusInWindow();
                    AntArtifactPropertiesEditor.this.myPropertiesTable.editCellAt(newIndex, i);
                    break;
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)AntArtifactPropertiesEditor.this.myPropertiesTable);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                ListSelectionModel selectionModel = AntArtifactPropertiesEditor.this.myPropertiesTable.getSelectionModel();
                ListTableModel model = (ListTableModel)AntArtifactPropertiesEditor.this.myPropertiesTable.getModel();
                boolean enable = false;
                if (!selectionModel.isSelectionEmpty()) {
                    enable = true;
                    for (int i : AntArtifactPropertiesEditor.this.myPropertiesTable.getSelectedRows()) {
                        if (!AntArtifactProperties.isPredefinedProperty(((BuildFileProperty)model.getItems().get(i)).getPropertyName())) continue;
                        enable = false;
                        break;
                    }
                }
                return enable;
            }
        }).disableUpDownActions().createPanel(), "Center");
        final AntConfiguration antConfiguration = AntConfiguration.getInstance(context.getProject());
        this.myAntConfigurationListener = new AntConfigurationListener(){

            @Override
            public void configurationLoaded() {
                if (AntArtifactPropertiesEditor.this.myTarget == null) {
                    AntArtifactPropertiesEditor.this.myTarget = AntArtifactPropertiesEditor.this.myProperties.findTarget(antConfiguration);
                    AntArtifactPropertiesEditor.this.updatePanel();
                }
            }

            @Override
            public void buildFileChanged(AntBuildFile buildFile) {
            }

            @Override
            public void buildFileAdded(AntBuildFile buildFile) {
            }

            @Override
            public void buildFileRemoved(AntBuildFile buildFile) {
            }
        };
        antConfiguration.addAntConfigurationListener(this.myAntConfigurationListener);
    }

    private void selectTarget() {
        TargetChooserDialog dialog = new TargetChooserDialog(this.myContext.getProject(), this.myTarget);
        if (dialog.showAndGet()) {
            this.myTarget = dialog.getSelectedTarget();
            this.updatePanel();
        }
    }

    private void updatePanel() {
        if (this.myTarget != null) {
            this.myRunTargetCheckBox.setText("Run Ant target '" + this.myTarget.getName() + "'");
        } else {
            this.myRunTargetCheckBox.setText("Run Ant target <none>");
        }
        boolean enabled = this.myTarget != null && this.myRunTargetCheckBox.isSelected();
        UIUtil.setEnabled((Component)this.myPropertiesPanel, (boolean)enabled, (boolean)true);
    }

    public String getTabName() {
        return this.myPostProcessing ? "Post-processing" : "Pre-processing";
    }

    public void apply() {
        VirtualFile file;
        this.myProperties.setEnabled(this.myRunTargetCheckBox.isSelected());
        if (this.myTarget != null && (file = this.myTarget.getModel().getBuildFile().getVirtualFile()) != null) {
            this.myProperties.setFileUrl(file.getUrl());
            this.myProperties.setTargetName(this.myTarget.getName());
            List<BuildFileProperty> properties = this.getUserProperties();
            this.myProperties.setUserProperties(properties);
            return;
        }
        this.myProperties.setFileUrl(null);
        this.myProperties.setTargetName(null);
    }

    private List<BuildFileProperty> getUserProperties() {
        SinglePropertyContainer<ListProperty<BuildFileProperty>> container = new SinglePropertyContainer<ListProperty<BuildFileProperty>>(ANT_PROPERTIES, null);
        this.myBinding.apply(container);
        List allProperties = (List)container.getValueOf(ANT_PROPERTIES);
        return ContainerUtil.filter((Collection)allProperties, USER_PROPERTY_CONDITION);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myProperties.isEnabled() != this.myRunTargetCheckBox.isSelected()) {
            return true;
        }
        if (this.myTarget == null) {
            return this.myProperties.getFileUrl() != null;
        }
        if (!Comparing.equal((String)this.myTarget.getName(), (String)this.myProperties.getTargetName())) {
            return true;
        }
        VirtualFile file = this.myTarget.getModel().getBuildFile().getVirtualFile();
        if (file != null && !Comparing.equal((String)file.getUrl(), (String)this.myProperties.getFileUrl())) {
            return true;
        }
        return !this.getUserProperties().equals(this.myProperties.getUserProperties());
    }

    public void reset() {
        this.myRunTargetCheckBox.setSelected(this.myProperties.isEnabled());
        this.myTarget = this.myProperties.findTarget(AntConfiguration.getInstance(this.myContext.getProject()));
        ArrayList<BuildFileProperty> properties = new ArrayList<BuildFileProperty>();
        for (BuildFileProperty property : this.myProperties.getAllProperties(this.myContext.getArtifact())) {
            properties.add(new BuildFileProperty(property.getPropertyName(), property.getPropertyValue()));
        }
        this.myContainer = new SinglePropertyContainer<ListProperty<BuildFileProperty>>(ANT_PROPERTIES, properties);
        this.myBinding.loadValues(this.myContainer);
        this.updatePanel();
    }

    public void disposeUIResources() {
        AntConfiguration.getInstance(this.myContext.getProject()).removeAntConfigurationListener(this.myAntConfigurationListener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        FixedSizeButton fixedSizeButton;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRunTargetCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("run");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySelectTargetButton = fixedSizeButton = new FixedSizeButton();
        jPanel3.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 250), null, 1));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Properties", (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

