/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameterListBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReflectedMethodImpl
extends LightMethodBuilder
implements GrReflectedMethod {
    private static final Logger LOG = Logger.getInstance(GrReflectedMethodImpl.class);
    @NonNls
    public static final String CATEGORY_PARAMETER_NAME = "self";
    private final GrMethod myBaseMethod;
    private GrParameter[] mySkippedParameters = null;

    public GrReflectedMethodImpl(GrMethod baseMethod, GrParameter[] parameters, int optionalParams, PsiClassType categoryType) {
        super(baseMethod.getManager(), baseMethod.getLanguage(), baseMethod.getName(), (PsiParameterList)new GrLightParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()), (PsiModifierList)new GrLightModifierList(baseMethod), (PsiReferenceList)new LightReferenceListBuilder(baseMethod.getManager(), baseMethod.getLanguage(), null), (PsiTypeParameterList)new LightTypeParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()));
        this.initParameterList(parameters, optionalParams, categoryType);
        this.initTypeParameterList(baseMethod);
        this.initModifiers(baseMethod, categoryType != null);
        this.initThrowsList(baseMethod);
        this.setContainingClass(baseMethod.getContainingClass());
        this.setMethodReturnType(baseMethod.getReturnType());
        this.setConstructor(baseMethod.isConstructor());
        this.myBaseMethod = baseMethod;
    }

    private void initTypeParameterList(GrMethod method) {
        for (PsiTypeParameter parameter : method.getTypeParameters()) {
            this.addTypeParameter(parameter);
        }
    }

    private void initThrowsList(GrMethod baseMethod) {
        for (PsiClassType exception : baseMethod.getThrowsList().getReferencedTypes()) {
            this.addException(exception);
        }
    }

    private void initModifiers(GrMethod baseMethod, boolean isCategoryMethod) {
        GrLightModifierList myModifierList = (GrLightModifierList)this.getModifierList();
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!baseMethod.hasModifierProperty(modifier)) continue;
            myModifierList.addModifier(modifier);
        }
        for (GrAnnotation annotation : baseMethod.getModifierList().getRawAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName != null) {
                myModifierList.addAnnotation(qualifiedName);
                continue;
            }
            myModifierList.addAnnotation(((GrAnnotation)annotation).getShortName());
        }
        if (isCategoryMethod) {
            myModifierList.addModifier("static");
        }
        if (this.mySkippedParameters.length != 0) {
            myModifierList.removeModifier(1024);
        }
    }

    private void initParameterList(GrParameter[] parameters, int optionalParams, PsiClassType categoryType) {
        GrLightParameterListBuilder parameterList = (GrLightParameterListBuilder)this.getParameterList();
        ArrayList<GrParameter> skipped = new ArrayList<GrParameter>();
        if (categoryType != null) {
            parameterList.addParameter(new GrLightParameter(CATEGORY_PARAMETER_NAME, (PsiType)categoryType, this));
        }
        for (GrParameter parameter : parameters) {
            if (parameter.isOptional()) {
                if (optionalParams < 1) {
                    skipped.add(parameter);
                    continue;
                }
                --optionalParams;
            }
            parameterList.addParameter(this.createLightParameter(parameter));
        }
        LOG.assertTrue(optionalParams == 0);
        this.mySkippedParameters = skipped.toArray(new GrParameter[skipped.size()]);
    }

    private GrLightParameter createLightParameter(GrParameter parameter) {
        GrLightParameter lightParameter = new GrLightParameter(parameter.getName(), parameter.getDeclaredType(), this);
        lightParameter.setModifierList(parameter.getModifierList());
        return lightParameter;
    }

    @Override
    @NotNull
    public GrMethod getBaseMethod() {
        GrMethod grMethod = this.myBaseMethod;
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getBaseMethod"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrParameter[] getSkippedParameters() {
        if (this.mySkippedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getSkippedParameters"));
        }
        return this.mySkippedParameters;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myBaseMethod.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public GrOpenBlock getBlock() {
        return this.myBaseMethod.getBlock();
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    public GrTypeElement getReturnTypeElementGroovy() {
        return this.myBaseMethod.getReturnTypeElementGroovy();
    }

    @Override
    public PsiType getInferredReturnType() {
        return this.myBaseMethod.getInferredReturnType();
    }

    @Override
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        Map<String, NamedArgumentDescriptor> map = this.myBaseMethod.getNamedParameters();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getNamedParameters"));
        }
        return map;
    }

    @Override
    @NotNull
    public GrReflectedMethod[] getReflectedMethods() {
        if (GrReflectedMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getReflectedMethods"));
        }
        return GrReflectedMethod.EMPTY_ARRAY;
    }

    @Override
    public GrMember[] getMembers() {
        return this.myBaseMethod.getMembers();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.myBaseMethod.getNameIdentifierGroovy();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Override
    public GrParameter[] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList grParameterList = (GrParameterList)super.getParameterList();
        if (grParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getParameterList"));
        }
        return grParameterList;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitMethod(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    @Override
    public GrDocComment getDocComment() {
        return this.myBaseMethod.getDocComment();
    }

    public String toString() {
        return this.getName() + " (" + StringUtil.join((Object[])this.getParameters(), f -> f.getType().getPresentableText() + " " + f.getName(), (String)", ") + ")";
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)super.getModifierList();
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getModifierList"));
        }
        return grModifierList;
    }

    public Icon getIcon(int flags) {
        return this.myBaseMethod.getIcon(flags);
    }

    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this.myBaseMethod);
    }

    public boolean isPhysical() {
        return this.myBaseMethod.isPhysical();
    }

    @NotNull
    public static GrReflectedMethod[] createReflectedMethods(GrMethod method) {
        GrReflectedMethod[] grReflectedMethodArray = (GrReflectedMethod[])CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters()), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (grReflectedMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "createReflectedMethods"));
        }
        return grReflectedMethodArray;
    }

    @NotNull
    public static GrReflectedMethod[] doCreateReflectedMethods(@NotNull GrMethod targetMethod, @Nullable PsiClassType categoryType, @NotNull GrParameter[] parameters) {
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "doCreateReflectedMethods"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "doCreateReflectedMethods"));
        }
        int count = 0;
        for (GrParameter parameter : parameters) {
            if (!parameter.isOptional()) continue;
            ++count;
        }
        if (count == 0 && categoryType == null) {
            if (GrReflectedMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "doCreateReflectedMethods"));
            }
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        GrReflectedMethod[] methods = new GrReflectedMethod[count + 1];
        for (int i = 0; i <= count; ++i) {
            methods[i] = new GrReflectedMethodImpl(targetMethod, parameters, count - i, categoryType);
        }
        if (methods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "doCreateReflectedMethods"));
        }
        return methods;
    }

    public static GrReflectedMethod[] createReflectedConstructors(GrMethod method) {
        assert (method.isConstructor());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        PsiClass enclosingClass = aClass.getContainingClass();
        if (enclosingClass != null && !aClass.hasModifierProperty("static")) {
            GrParameter[] parameters = GrInnerClassConstructorUtil.addEnclosingInstanceParam(method, enclosingClass, method.getParameterList().getParameters(), false);
            GrReflectedMethod[] reflectedMethods = GrReflectedMethodImpl.doCreateReflectedMethods(method, null, parameters);
            if (reflectedMethods.length > 0) {
                return reflectedMethods;
            }
            return new GrReflectedMethod[]{new GrReflectedMethodImpl(method, parameters, 0, null)};
        }
        return GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters());
    }

    @Nullable
    private static PsiClassType getCategoryType(GrMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return GdkMethodUtil.getCategoryType(containingClass);
    }

    @NotNull
    public PsiElement getPrototype() {
        GrMethod grMethod = this.getBaseMethod();
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl", "getPrototype"));
        }
        return grMethod;
    }
}

