/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.listeners;

import java.util.stream.Stream;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;
import org.junit.gen5.launcher.listeners.TestExecutionSummary;

@API(value=API.Usage.Experimental)
public class SummaryGeneratingListener
implements TestExecutionListener {
    private TestPlan testPlan;
    private TestExecutionSummary summary;

    public TestExecutionSummary getSummary() {
        return this.summary;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summary = new TestExecutionSummary(testPlan);
        this.summary.testsFound.set(testPlan.countTestIdentifiers(TestIdentifier::isTest));
        this.summary.timeStarted = System.currentTimeMillis();
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summary.finishTestRun("Test run finished");
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.summary.testsFound.incrementAndGet();
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        long skippedTests = Stream.concat(Stream.of(testIdentifier), this.testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isTest).count();
        this.summary.testsSkipped.addAndGet(skippedTests);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.summary.testsStarted.incrementAndGet();
        }
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL) {
                this.summary.testsSucceeded.incrementAndGet();
            } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
                this.summary.testsAborted.incrementAndGet();
            } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                this.summary.testsFailed.incrementAndGet();
            }
        }
        testExecutionResult.getThrowable().ifPresent(throwable -> this.summary.addFailure(testIdentifier, (Throwable)throwable));
    }
}

