/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.struct.StructContext;

public class ImportCollector {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private final Map<String, String> mapSimpleNames = new HashMap<String, String>();
    private final Set<String> setNotImportedNames = new HashSet<String>();
    private final String currentPackageSlash;
    private final String currentPackagePoint;

    public ImportCollector(ClassesProcessor.ClassNode root) {
        String clName = root.classStruct.qualifiedName;
        int index = clName.lastIndexOf(47);
        if (index >= 0) {
            String packageName = clName.substring(0, index);
            this.currentPackageSlash = packageName + '/';
            this.currentPackagePoint = packageName.replace('/', '.');
        } else {
            this.currentPackageSlash = "";
            this.currentPackagePoint = "";
        }
    }

    public String getShortName(String fullName) {
        return this.getShortName(fullName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getShortName(String fullName, boolean imported) {
        StructContext context;
        boolean existsDefaultClass;
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(fullName.replace('.', '/'));
        String result = null;
        if (node != null && node.classStruct.isOwn()) {
            result = node.simpleName;
            while (node.parent != null && node.type == 1) {
                result = node.parent.simpleName + '.' + result;
                node = node.parent;
            }
            if (node.type != 0) return result;
            fullName = node.classStruct.qualifiedName;
            fullName = fullName.replace('/', '.');
        } else {
            fullName = fullName.replace('$', '.');
        }
        String shortName = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot >= 0) {
            shortName = fullName.substring(lastDot + 1);
            packageName = fullName.substring(0, lastDot);
        }
        boolean bl = existsDefaultClass = (context = DecompilerContext.getStructContext()).getClass(this.currentPackageSlash + shortName) != null && !packageName.equals(this.currentPackagePoint) || context.getClass(shortName) != null && !this.currentPackagePoint.isEmpty();
        if (existsDefaultClass || this.mapSimpleNames.containsKey(shortName) && !packageName.equals(this.mapSimpleNames.get(shortName))) {
            return result == null ? fullName : packageName + "." + result;
        }
        if (this.mapSimpleNames.containsKey(shortName)) return result == null ? shortName : result;
        this.mapSimpleNames.put(shortName, packageName);
        if (imported) return result == null ? shortName : result;
        this.setNotImportedNames.add(shortName);
        return result == null ? shortName : result;
    }

    public int writeImports(TextBuffer buffer) {
        int importLinesWritten = 0;
        List<String> imports = this.packImports();
        for (String s : imports) {
            buffer.append("import ");
            buffer.append(s);
            buffer.append(';');
            buffer.appendLineSeparator();
            ++importLinesWritten;
        }
        return importLinesWritten;
    }

    private List<String> packImports() {
        ArrayList<Map.Entry<String, String>> lst = new ArrayList<Map.Entry<String, String>>(this.mapSimpleNames.entrySet());
        Collections.sort(lst, (par0, par1) -> {
            int res = ((String)par0.getValue()).compareTo((String)par1.getValue());
            if (res == 0) {
                res = ((String)par0.getKey()).compareTo((String)par1.getKey());
            }
            return res;
        });
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry entry : lst) {
            if (this.setNotImportedNames.contains(entry.getKey()) || JAVA_LANG_PACKAGE.equals(entry.getValue()) || ((String)entry.getValue()).isEmpty()) continue;
            res.add((String)entry.getValue() + "." + (String)entry.getKey());
        }
        return res;
    }
}

