/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.common.util.locks.RecursiveLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01CompleteFair
implements RecursiveLock {
    private final Sync sync = new Sync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.lockedStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOwner(Thread thread) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner() == thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = this.sync.getOwner();
            return null != thread && Thread.currentThread() != thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.holdCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateLocked() throws RuntimeException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (Thread.currentThread() != this.sync.getOwner()) {
                if (null == this.sync.getOwner()) {
                    String string = this.threadName(Thread.currentThread());
                    String string2 = this.toString();
                    throw new RuntimeException(new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": Not locked: ").append(string2).toString());
                }
                if (null != this.sync.lockedStack) {
                    this.sync.lockedStack.printStackTrace();
                }
                String string = String.valueOf(Thread.currentThread());
                String string3 = this.toString();
                throw new RuntimeException(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(": Not owner: ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.lockedStack) {
                        this.sync.lockedStack.printStackTrace();
                    }
                    long l = TIMEOUT;
                    String string = this.toString();
                    String string2 = this.threadName(Thread.currentThread());
                    throw new RuntimeException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Waited ").append(l).append("ms for: ").append(string).append(" - ").append(string2).toString());
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryLock(long l) throws InterruptedException {
        Sync sync = this.sync;
        synchronized (sync) {
            String string;
            Object object;
            Thread thread = Thread.currentThread();
            if (TRACE_LOCK) {
                object = this.toString();
                string = this.threadName(thread);
                System.err.println(new StringBuilder(17 + String.valueOf(object).length() + String.valueOf(string).length()).append("+++ LOCK 0 ").append((String)object).append(", cur ").append(string).toString());
            }
            if (this.sync.getOwner() == thread) {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    object = this.toString();
                    string = this.threadName(thread);
                    System.err.println(new StringBuilder(18 + String.valueOf(object).length() + String.valueOf(string).length()).append("+++ LOCK XR ").append((String)object).append(", cur ").append(string).toString());
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l && 0 < this.sync.queue.size()) {
                if (0L >= l) {
                    if (TRACE_LOCK) {
                        object = this.toString();
                        string = this.threadName(thread);
                        long l2 = l;
                        System.err.println(new StringBuilder(48 + String.valueOf(object).length() + String.valueOf(string).length()).append("+++ LOCK XY ").append((String)object).append(", cur ").append(string).append(", left ").append(l2).append(" ms").toString());
                    }
                    return false;
                }
                object = new WaitingThread(thread);
                this.sync.queue.add(0, (WaitingThread)object);
                do {
                    long l3 = System.currentTimeMillis();
                    try {
                        this.sync.wait(l);
                        l -= System.currentTimeMillis() - l3;
                    }
                    catch (InterruptedException interruptedException) {
                        if (!((WaitingThread)object).signaledByUnlock) {
                            this.sync.queue.remove(object);
                            throw SourcedInterruptedException.wrap(interruptedException);
                        }
                        if (thread == this.sync.getOwner()) continue;
                        l -= System.currentTimeMillis() - l3;
                        if (TRACE_LOCK) {
                            String string2 = this.toString();
                            String string3 = this.threadName(thread);
                            long l4 = l;
                            boolean bl = ((WaitingThread)object).signaledByUnlock;
                            System.err.println(new StringBuilder(64 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("+++ LOCK 1 ").append(string2).append(", cur ").append(string3).append(", left ").append(l4).append(" ms, signaled: ").append(bl).toString());
                        }
                        if (0L >= l) continue;
                        ((WaitingThread)object).signaledByUnlock = false;
                        this.sync.queue.add(this.sync.queue.size(), (WaitingThread)object);
                    }
                } while (thread != this.sync.getOwner() && 0L < l);
                Thread.interrupted();
                if (0L >= l && thread != this.sync.getOwner()) {
                    if (!((WaitingThread)object).signaledByUnlock) {
                        this.sync.queue.remove(object);
                    }
                    if (TRACE_LOCK) {
                        String string4 = this.toString();
                        String string5 = this.threadName(thread);
                        long l5 = l;
                        System.err.println(new StringBuilder(48 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("+++ LOCK XX ").append(string4).append(", cur ").append(string5).append(", left ").append(l5).append(" ms").toString());
                    }
                    return false;
                }
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    String string6 = this.toString();
                    String string7 = this.threadName(thread);
                    long l6 = l;
                    System.err.println(new StringBuilder(48 + String.valueOf(string6).length() + String.valueOf(string7).length()).append("+++ LOCK X1 ").append(string6).append(", cur ").append(string7).append(", left ").append(l6).append(" ms").toString());
                }
            } else {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    object = this.toString();
                    string = this.threadName(thread);
                    System.err.println(new StringBuilder(18 + String.valueOf(object).length() + String.valueOf(string).length()).append("+++ LOCK X0 ").append((String)object).append(", cur ").append(string).toString());
                }
            }
            this.sync.setOwner(thread);
            if (DEBUG) {
                String string8 = String.valueOf(this.toString());
                this.sync.setLockedStack(new Throwable(string8.length() != 0 ? "Previously locked by ".concat(string8) : new String("Previously locked by ")));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread = Thread.currentThread();
            --this.sync.holdCount;
            if (this.sync.holdCount > 0) {
                if (TRACE_LOCK) {
                    String string = this.toString();
                    String string2 = this.threadName(thread);
                    System.err.println(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("--- LOCK XR ").append(string).append(", cur ").append(string2).toString());
                }
                return;
            }
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (null != runnable) {
                runnable.run();
            }
            if (this.sync.queue.size() > 0) {
                WaitingThread waitingThread = this.sync.queue.remove(this.sync.queue.size() - 1);
                this.sync.setOwner(waitingThread.thread);
                if (TRACE_LOCK) {
                    String string = this.toString();
                    String string3 = this.threadName(thread);
                    String string4 = this.threadName(waitingThread.thread);
                    System.err.println(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("--- LOCK X1 ").append(string).append(", cur ").append(string3).append(", signal: ").append(string4).toString());
                }
                waitingThread.signaledByUnlock = true;
                waitingThread.thread.interrupt();
            } else {
                this.sync.setOwner(null);
                if (TRACE_LOCK) {
                    String string = this.toString();
                    String string5 = this.threadName(thread);
                    System.err.println(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string5).length()).append("--- LOCK X0 ").append(string).append(", cur ").append(string5).append(", signal any").toString());
                }
                this.sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.queue.size();
        }
    }

    public String toString() {
        String string = this.syncName();
        int n = this.sync.holdCount;
        int n2 = this.sync.queue.size();
        String string2 = this.threadName(this.sync.getOwner());
        return new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[count ").append(n).append(", qsz ").append(n2).append(", owner ").append(string2).append("]").toString();
    }

    private final String syncName() {
        String string = String.valueOf(Integer.toHexString(this.hashCode()));
        String string2 = String.valueOf(Integer.toHexString(this.sync.hashCode()));
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append(", ").append(string2).append(">").toString();
    }

    private final String threadName(Thread thread) {
        String string;
        if (null != thread) {
            String string2 = String.valueOf(thread.getName());
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("<").append(string2).append(">").toString();
        } else {
            string = "<NULL>";
        }
        return string;
    }

    private static class Sync
    extends AbstractOwnableSynchronizer {
        private int holdCount = 0;
        final ArrayList<WaitingThread> queue = new ArrayList();
        private Throwable lockedStack = null;

        private Sync() {
        }

        private final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        private final void setOwner(Thread thread) {
            this.setExclusiveOwnerThread(thread);
        }

        private final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }
    }

    private static class WaitingThread {
        final Thread thread;
        boolean signaledByUnlock;

        WaitingThread(Thread thread) {
            this.thread = thread;
            this.signaledByUnlock = false;
        }
    }
}

