/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import java.util.Arrays;
import jogamp.common.util.locks.RecursiveLockImpl01Unfairish;

public class RecursiveThreadGroupLockImpl01Unfairish
extends RecursiveLockImpl01Unfairish
implements RecursiveThreadGroupLock {
    public RecursiveThreadGroupLockImpl01Unfairish() {
        super(new ThreadGroupSync());
    }

    @Override
    public final boolean isOriginalOwner() {
        return this.isOriginalOwner(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOriginalOwner(Thread thread) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            return ((ThreadGroupSync)this.sync).isOriginalOwner(thread);
        }
    }

    @Override
    public final void addOwner(Thread thread) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        Thread thread2 = Thread.currentThread();
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        if (!threadGroupSync.isOriginalOwner(thread2)) {
            String string = String.valueOf(threadGroupSync.getOwner());
            String string2 = String.valueOf(thread2);
            String string3 = this.toString();
            throw new IllegalArgumentException(new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Current thread is not the original owner: orig-owner: ").append(string).append(", current ").append(string2).append(": ").append(string3).toString());
        }
        if (threadGroupSync.isOriginalOwner(thread)) {
            String string = String.valueOf(thread);
            String string4 = this.toString();
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Passed thread is original owner: ").append(string).append(", ").append(string4).toString());
        }
        threadGroupSync.addOwner(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            String string;
            Object object;
            Thread thread = Thread.currentThread();
            ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
            if (threadGroupSync.getAddOwnerCount() > 0) {
                if (TRACE_LOCK) {
                    object = this.toString();
                    string = this.threadName(thread);
                    System.err.println(new StringBuilder(35 + String.valueOf(object).length() + String.valueOf(string).length()).append("--- LOCK XR (tg) ").append((String)object).append(", cur ").append(string).append(" -> owner...").toString());
                }
                if (threadGroupSync.isOriginalOwner(thread)) {
                    if (threadGroupSync.getHoldCount() - threadGroupSync.getAdditionalOwnerHoldCount() == 1) {
                        threadGroupSync.setWaitingOrigOwner(thread);
                        try {
                            while (threadGroupSync.getAdditionalOwnerHoldCount() > 0) {
                                try {
                                    this.sync.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        finally {
                            threadGroupSync.setWaitingOrigOwner(null);
                            Thread.interrupted();
                        }
                        threadGroupSync.removeAllOwners();
                    }
                } else if (threadGroupSync.getAdditionalOwnerHoldCount() == 1 && null != (object = threadGroupSync.getWaitingOrigOwner())) {
                    ((Thread)object).interrupt();
                }
            }
            if (TRACE_LOCK) {
                object = String.valueOf(thread.getName());
                string = this.toString();
                System.err.println(new StringBuilder(36 + String.valueOf(object).length() + String.valueOf(string).length()).append("++ unlock(X): currentThread ").append((String)object).append(", lock: ").append(string).toString());
                object = this.toString();
                string = this.threadName(thread);
                System.err.println(new StringBuilder(34 + String.valueOf(object).length() + String.valueOf(string).length()).append("--- LOCK X0 (tg) ").append((String)object).append(", cur ").append(string).append(" -> unlock!").toString());
            }
            super.unlock(runnable);
        }
    }

    @Override
    public final void removeOwner(Thread thread) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        ((ThreadGroupSync)this.sync).removeOwner(thread);
    }

    @Override
    public String toString() {
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        int n = this.sync.getHoldCount();
        int n2 = threadGroupSync.getAdditionalOwnerHoldCount();
        String string = this.syncName();
        int n3 = n - n2;
        int n4 = this.sync.getQSz();
        String string2 = this.threadName(this.sync.getOwner());
        String string3 = threadGroupSync.addOwnerToString();
        return new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("[count ").append(n).append(" [ add. ").append(n2).append(", orig ").append(n3).append("], qsz ").append(n4).append(", owner ").append(string2).append(", add.owner ").append(string3).append("]").toString();
    }

    static class ThreadGroupSync
    extends RecursiveLockImpl01Unfairish.SingleThreadSync {
        private int holdCountAdditionOwner = 0;
        private Thread[] threads = null;
        private int threadNum = 0;
        private Thread waitingOrigOwner = null;

        ThreadGroupSync() {
        }

        @Override
        public final void incrHoldCount(Thread thread) {
            super.incrHoldCount(thread);
            if (!this.isOriginalOwner(thread)) {
                ++this.holdCountAdditionOwner;
            }
        }

        @Override
        public final void decrHoldCount(Thread thread) {
            super.decrHoldCount(thread);
            if (!this.isOriginalOwner(thread)) {
                --this.holdCountAdditionOwner;
            }
        }

        public final int getAdditionalOwnerHoldCount() {
            return this.holdCountAdditionOwner;
        }

        public final boolean isOriginalOwner(Thread thread) {
            return super.isOwner(thread);
        }

        public final void setWaitingOrigOwner(Thread thread) {
            this.waitingOrigOwner = thread;
        }

        public final Thread getWaitingOrigOwner() {
            return this.waitingOrigOwner;
        }

        @Override
        public final boolean isOwner(Thread thread) {
            if (this.getExclusiveOwnerThread() == thread) {
                return true;
            }
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                if (this.threads[i] != thread) continue;
                return true;
            }
            return false;
        }

        public final int getAddOwnerCount() {
            return this.threadNum;
        }

        public final void addOwner(Thread thread) throws IllegalArgumentException {
            if (null == this.threads) {
                if (this.threadNum > 0) {
                    throw new InternalError("XXX");
                }
                this.threads = new Thread[4];
            }
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                if (this.threads[i] != thread) continue;
                String string = String.valueOf(thread);
                throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Thread already added: ").append(string).toString());
            }
            if (this.threadNum == this.threads.length) {
                this.threads = Arrays.copyOf(this.threads, this.threadNum * 2);
            }
            this.threads[this.threadNum] = thread;
            ++this.threadNum;
        }

        public final void removeAllOwners() {
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                this.threads[i] = null;
            }
            this.threadNum = 0;
        }

        public final void removeOwner(Thread thread) throws IllegalArgumentException {
            for (int i = 0; i < this.threadNum; ++i) {
                if (this.threads[i] != thread) continue;
                --this.threadNum;
                System.arraycopy(this.threads, i + 1, this.threads, i, this.threadNum - i);
                this.threads[this.threadNum] = null;
                return;
            }
            String string = String.valueOf(thread);
            throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append("Not an owner: ").append(string).toString());
        }

        String addOwnerToString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.threadNum; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.threads[i].getName());
            }
            return stringBuilder.toString();
        }
    }
}

