/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomGenerateProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    public static final String NAMESPACE_PREFIX_VAR = "NS_PREFIX";
    @Nullable
    private final String myMappingId;

    public AbstractDomGenerateProvider(String description, Class<T> aClass) {
        this(description, aClass, null);
    }

    public AbstractDomGenerateProvider(String description, Class<T> aClass, @Nullable String mappingId) {
        super(description, aClass);
        this.myMappingId = mappingId;
    }

    @Override
    public T generate(Project project, Editor editor, PsiFile file) {
        DomElement parentDomElement = this.getParentDomElement(project, editor, file);
        Object t = this.generate(parentDomElement, editor);
        this.runTemplate(editor, file, t, this.getPredefinedVars(parentDomElement, t, editor, file));
        return t;
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable T t, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider", "getPredefinedVars"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider", "getPredefinedVars"));
        }
        return AbstractDomGenerateProvider.createNamespacePrefixMap(parentDomElement);
    }

    @NotNull
    public static Map<String, String> createNamespacePrefixMap(@Nullable DomElement domElement) {
        HashMap vars = new HashMap();
        AbstractDomGenerateProvider.addNamespacePrefix(domElement, (Map<String, String>)vars);
        HashMap hashMap = vars;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider", "createNamespacePrefixMap"));
        }
        return hashMap;
    }

    public static void addNamespacePrefix(@Nullable DomElement domElement, @NotNull Map<String, String> vars) {
        String namespacePrefix;
        XmlTag tag;
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider", "addNamespacePrefix"));
        }
        if (domElement != null && (tag = domElement.getXmlTag()) != null && !StringUtil.isEmptyOrSpaces((String)(namespacePrefix = tag.getNamespacePrefix()))) {
            vars.put(NAMESPACE_PREFIX_VAR, namespacePrefix + ":");
        }
    }

    protected void runTemplate(Editor editor, PsiFile file, T t, Map<String, String> predefinedVars) {
        DomTemplateRunner.getInstance(file.getProject()).runTemplate(t, this.myMappingId, editor, predefinedVars);
    }

    @Override
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Override
    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        DomElement element = this.getElementToNavigate(copy);
        if (element != null) {
            super.doNavigate(navigateProvider, element);
        }
    }

    @Nullable
    protected DomElement getElementToNavigate(T t) {
        return t;
    }

    protected static String getDescription(Class<? extends DomElement> aClass) {
        return StringUtil.join(Arrays.asList(NameUtil.nameToWords((String)aClass.getSimpleName())), (String)" ");
    }

    @Nullable
    public String getMappingId() {
        return this.myMappingId;
    }
}

