/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.Environment;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonMetricsData {
    public static AndroidStudioStats.ProductDetails.CpuArchitecture getOsArchitecture() {
        AndroidStudioStats.ProductDetails.CpuArchitecture jvmArchitecture = CommonMetricsData.getJvmArchitecture();
        if (jvmArchitecture == AndroidStudioStats.ProductDetails.CpuArchitecture.X86) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("win")) {
                String w6432 = Environment.getInstance().getVariable("PROCESSOR_ARCHITEW6432");
                if (w6432 != null && w6432.contains("64")) {
                    return AndroidStudioStats.ProductDetails.CpuArchitecture.X86_64;
                }
            } else if (os.startsWith("linux")) {
                String s = Environment.getInstance().getVariable("HOSTTYPE");
                return CommonMetricsData.cpuArchitectureFromString(s);
            }
        }
        return jvmArchitecture;
    }

    public static AndroidStudioStats.ProductDetails.CpuArchitecture getJvmArchitecture() {
        String arch = System.getProperty("os.arch");
        return CommonMetricsData.cpuArchitectureFromString(arch);
    }

    public static AndroidStudioStats.ProductDetails.CpuArchitecture cpuArchitectureFromString(String cpuArchitecture) {
        if (cpuArchitecture == null || cpuArchitecture.length() == 0) {
            return AndroidStudioStats.ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
        }
        if (cpuArchitecture.equalsIgnoreCase("x86_64") || cpuArchitecture.equalsIgnoreCase("ia64") || cpuArchitecture.equalsIgnoreCase("amd64")) {
            return AndroidStudioStats.ProductDetails.CpuArchitecture.X86_64;
        }
        if (cpuArchitecture.equalsIgnoreCase("x86")) {
            return AndroidStudioStats.ProductDetails.CpuArchitecture.X86;
        }
        if (cpuArchitecture.length() == 4 && cpuArchitecture.charAt(0) == 'i' && cpuArchitecture.indexOf("86") == 2) {
            return AndroidStudioStats.ProductDetails.CpuArchitecture.X86;
        }
        return AndroidStudioStats.ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
    }

    public static String getOsName() {
        String os = System.getProperty("os.name");
        if (os == null || os.length() == 0) {
            return "unknown";
        }
        String osLower = os.toLowerCase(Locale.US);
        if (osLower.startsWith("mac")) {
            os = "macosx";
        } else if (osLower.startsWith("win")) {
            os = "windows";
        } else if (osLower.startsWith("linux")) {
            os = "linux";
        } else if (os.length() > 32) {
            os = os.substring(0, 32);
        }
        return os;
    }

    public static String getMajorOsVersion() {
        Matcher m;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = System.getProperty("os.version");
        if (osVers != null && osVers.length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        return null;
    }

    public static AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface applicationBinaryInterfaceFromString(String value) {
        if (value == null) {
            return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (value) {
            case "armeabi-v6j": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6J;
            }
            case "armeabi-v6l": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6L;
            }
            case "armeabi-v7a": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
            }
            case "armeabi": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
            }
            case "arm64-v8a": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
            }
            case "mips": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
            }
            case "mips-r2": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
            }
            case "x86": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.X86_ABI;
            }
            case "x86_64": {
                return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
            }
        }
        return AndroidStudioStats.DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
    }
}

