/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 '2\u00020\u0001:\u0001'B1\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0016J8\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0006H\u0004J \u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH$J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH$J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0003H$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "stdlibArtifactId", "", "testArtifactId", "addJunit", "", "name", "presentableText", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "changePomFile", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "version", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "createExecution", "pomFile", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "executionId", "goalName", "isTest", "createExecutions", "getName", "getPresentableText", "isApplicable", "isConfigured", "isKotlinModule", "isRelevantGoal", "Companion", "idea-maven"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    private final String stdlibArtifactId;
    private final String testArtifactId;
    private final boolean addJunit;
    private final String name;
    private final String presentableText;
    @NotNull
    private static final String NAME = "maven";
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinPluginUtil.isMavenModule(module);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConfigured(@NotNull Module module) {
        boolean bl;
        block11: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            if (!this.isKotlinModule(module)) {
                return false;
            }
            PsiFile psi = KotlinMavenConfigurator.Companion.findModulePomFile(module);
            if (psi == null || !psi.isValid() || !(psi instanceof XmlFile) || ((XmlFile)psi).getVirtualFile() == null || MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)((XmlFile)psi).getVirtualFile()) == null) {
                return false;
            }
            MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
            if (mavenProject == null) {
                return false;
            }
            MavenProject mavenProject2 = mavenProject;
            MavenPlugin mavenPlugin = mavenProject2.findPlugin(Companion.getGROUP_ID(), Companion.getMAVEN_PLUGIN_ID());
            if (mavenPlugin == null) {
                return false;
            }
            MavenPlugin plugin = mavenPlugin;
            List list2 = plugin.getExecutions();
            if (list2 != null) {
                void $receiver$iv;
                Iterable iterable = list2;
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block10: {
                        MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv;
                        List list3 = it.getGoals();
                        if (list3 != null) {
                            void $receiver$iv2;
                            Iterable iterable2 = list3;
                            for (Object element$iv2 : $receiver$iv2) {
                                String it2 = (String)element$iv2;
                                if (!(it2 != null && this.isRelevantGoal(it2))) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules);
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(this, project, dialog2){
            final /* synthetic */ KotlinMavenConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void run() {
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                List<Module> list2 = this.$dialog.getModulesToConfigure();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dialog.modulesToConfigure");
                for (Module module : MavenModulesRelationshipKt.excludeMavenChildrenModules(this.$project, list2)) {
                    PsiFile file2 = org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$findModulePomFile(KotlinMavenConfigurator.Companion, module);
                    if (file2 != null && org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$canConfigureFile(KotlinMavenConfigurator.Companion, file2)) {
                        String string = this.$dialog.getKotlinVersion();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
                        this.this$0.changePomFile(module, file2, string, collector2);
                        OpenFileAction.openFile((VirtualFile)file2.getVirtualFile(), (Project)this.$project);
                        continue;
                    }
                    org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$showErrorMessage(KotlinMavenConfigurator.Companion, this.$project, "Cannot find pom.xml for module " + module.getName());
                }
                collector2.showNotification();
            }
            {
                this.this$0 = kotlinMavenConfigurator;
                this.$project = project;
                this.$dialog = configureDialogWithModulesAndVersion;
            }
        });
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    public final void changePomFile(@NotNull Module module, @NotNull PsiFile file2, @NotNull String version, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            String string = "Virtual file should exists for psi file " + file2.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile3 = virtualFile2;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)virtualFile3);
        if (domModel == null) {
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            KotlinMavenConfigurator.Companion.showErrorMessage(project, null);
            return;
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        }
        PomFile pom = new PomFile((XmlFile)psiFile);
        pom.addProperty(KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY(), version);
        pom.addDependency(new MavenId(Companion.getGROUP_ID(), this.stdlibArtifactId, "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom.addDependency(new MavenId(Companion.getGROUP_ID(), this.testArtifactId, "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if (ConfigureKotlinInProjectUtilsKt.isSnapshot(version)) {
            pom.addLibraryRepository(ConfigureKotlinInProjectUtilsKt.SNAPSHOT_REPOSITORY);
            pom.addPluginRepository(ConfigureKotlinInProjectUtilsKt.SNAPSHOT_REPOSITORY);
        }
        if (ConfigureKotlinInProjectUtilsKt.isEap(version)) {
            pom.addLibraryRepository(ConfigureKotlinInProjectUtilsKt.EAP_REPOSITORY);
            pom.addPluginRepository(ConfigureKotlinInProjectUtilsKt.EAP_REPOSITORY);
        }
        MavenDomPlugin plugin = pom.addPlugin(new MavenId(Companion.getGROUP_ID(), Companion.getMAVEN_PLUGIN_ID(), "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"));
        this.createExecutions(pom, plugin, module);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file2));
        collector2.addMessage(virtualFile3.getPath() + " was modified");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module, boolean isTest) {
        Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkParameterIsNotNull((Object)executionId, (String)"executionId");
        Intrinsics.checkParameterIsNotNull((Object)goalName, (String)"goalName");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        pomFile.addKotlinExecution(module, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
        if (KotlinMavenConfigurator.Companion.hasJavaFiles(module)) {
            pomFile.addJavacExecutions(module, kotlinPlugin);
        }
    }

    protected KotlinMavenConfigurator(@NotNull String stdlibArtifactId, @Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        Intrinsics.checkParameterIsNotNull((Object)stdlibArtifactId, (String)"stdlibArtifactId");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)presentableText, (String)"presentableText");
        this.stdlibArtifactId = stdlibArtifactId;
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    static {
        NAME = NAME;
        GROUP_ID = GROUP_ID;
        MAVEN_PLUGIN_ID = MAVEN_PLUGIN_ID;
        KOTLIN_VERSION_PROPERTY = KOTLIN_VERSION_PROPERTY;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "()V", "GROUP_ID", "", "getGROUP_ID", "()Ljava/lang/String;", "KOTLIN_VERSION_PROPERTY", "getKOTLIN_VERSION_PROPERTY", "MAVEN_PLUGIN_ID", "getMAVEN_PLUGIN_ID", "NAME", "getNAME", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "findModulePomFile", "module", "Lcom/intellij/openapi/module/Module;", "hasJavaFiles", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "idea-maven"})
    public static final class Companion {
        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getMAVEN_PLUGIN_ID() {
            return MAVEN_PLUGIN_ID;
        }

        private final String getKOTLIN_VERSION_PROPERTY() {
            return KOTLIN_VERSION_PROPERTY;
        }

        private final boolean hasJavaFiles(Module module) {
            return !FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module)).isEmpty();
        }

        private final PsiFile findModulePomFile(Module module) {
            List files2 = MavenProjectsManager.getInstance((Project)module.getProject()).getProjectsFiles();
            for (VirtualFile file2 : files2) {
                PsiFile psiFile;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)module.getProject());
                if (Intrinsics.areEqual((Object)module, (Object)fileModule) ^ true) continue;
                if (PsiManager.getInstance((Project)module.getProject()).findFile(file2) == null) {
                    continue;
                }
                if (!MavenDomUtil.isProjectFile((PsiFile)psiFile)) continue;
                return psiFile;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), (Project)null);
        }

        private final void showErrorMessage(Project project, String message2) {
            Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-maven plugin automatically.<br/>" + (message2 != null ? message2 + "</br>" : "") + "See manual installation instructions <a href=\"http://confluence.jetbrains.com/display/Kotlin/Kotlin+Build+Tools#KotlinBuildTools-Maven\">here</a>.</html>"), (String)"Configure Kotlin-Maven Plugin");
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$canConfigureFile(Companion $this, @NotNull PsiFile file2) {
            return $this.canConfigureFile(file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

