/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.SubpackagesIndexService;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u0011H\u0007J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/PackageIndexUtil;", "", "()V", "containsFilesWithExactPackage", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findFilesWithExactPackage", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "getSubPackageFqNames", "scope", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "packageExists", "idea-analysis"})
public final class PackageIndexUtil {
    public static final PackageIndexUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final Collection<FqName> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2, @NotNull Project project, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(nameFilter2, (String)"nameFilter");
        return SubpackagesIndexService.Companion.getInstance(project).getSubpackages(packageFqName, scope2, nameFilter2);
    }

    @JvmStatic
    @NotNull
    public static final Collection<KtFile> findFilesWithExactPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection<KtFile> collection = KotlinExactPackagesIndex.getInstance().get(packageFqName.asString(), project, searchScope2);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinExactPackagesIndex\u2026(), project, searchScope)");
        return collection;
    }

    @JvmStatic
    public static final boolean packageExists(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        SubpackagesIndexService.SubpackagesIndex subpackagesIndex = SubpackagesIndexService.Companion.getInstance(project);
        if (!subpackagesIndex.packageExists(packageFqName)) {
            return false;
        }
        return PackageIndexUtil.containsFilesWithExactPackage(packageFqName, searchScope2, project) || subpackagesIndex.hasSubpackages(packageFqName, searchScope2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean containsFilesWithExactPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2, @NotNull Project project) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        StubIndex.getInstance().processElements(KotlinExactPackagesIndex.getInstance().getKey(), (Object)packageFqName.asString(), project, searchScope2, KtFile.class, (Processor)new Processor<KtFile>((Ref.BooleanRef)result2){
            final /* synthetic */ Ref.BooleanRef $result;

            public final boolean process(KtFile it) {
                this.$result.element = true;
                return false;
            }
            {
                this.$result = booleanRef;
            }
        });
        return result2.element;
    }

    private PackageIndexUtil() {
        INSTANCE = this;
    }

    static {
        new PackageIndexUtil();
    }
}

