/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.ReflectionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0014J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$J\f\u0010\"\u001a\u00020\u000b*\u00020\u000eH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "ANY_MEMBER_NAMES", "", "", "isWholeReflectionApiAvailable", "", "()Z", "kPropertyClasses", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isAllowedReflectionApi", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "containingClass", "isReflectionSource", "report", "element", "isKPropertyClass", "frontend"})
public abstract class AbstractReflectionApiCallChecker
implements CallChecker {
    private final NotNullLazyValue kPropertyClasses$delegate;
    private final Set<String> ANY_MEMBER_NAMES;
    private final ModuleDescriptor module;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    protected abstract boolean isWholeReflectionApiAvailable();

    protected abstract void report(@NotNull PsiElement var1, @NotNull CallCheckerContext var2);

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return (Set)StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[0]);
    }

    @Override
    public final void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.isWholeReflectionApiAvailable()) {
            return;
        }
        if (this.isReflectionSource(reportOn)) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        Object obj = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"descriptor");
        if (!this.isAllowedReflectionApi((CallableDescriptor)obj, containingClass)) {
            this.report(reportOn, context);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull CallableDescriptor descriptor2, @NotNull ClassDescriptor containingClass) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Name name2 = descriptor2.getName();
        return this.ANY_MEMBER_NAMES.contains(name2.asString()) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.INVOKE) || Intrinsics.areEqual((Object)name2.asString(), (Object)"name") || (Intrinsics.areEqual((Object)name2.asString(), (Object)"get") || Intrinsics.areEqual((Object)name2.asString(), (Object)"set")) && this.isKPropertyClass(containingClass);
    }

    private final boolean isKPropertyClass(@NotNull ClassDescriptor $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = this.getKPropertyClasses();
            for (Object element$iv : $receiver$iv) {
                ClassDescriptor kProperty = (ClassDescriptor)element$iv;
                if (!DescriptorUtils.isSubclass($receiver, kProperty)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isReflectionSource(PsiElement reportOn) {
        PsiFile psiFile = reportOn.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        FqNameUnsafe fqName2 = file2.getPackageFqName().toUnsafe();
        return Intrinsics.areEqual((Object)fqName2, (Object)ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().toUnsafe()) || StringsKt.startsWith$default((String)fqName2.asString(), (String)(ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().asString() + "."), (boolean)false, (int)2, null);
    }

    public AbstractReflectionApiCallChecker(@NotNull ModuleDescriptor module, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.module = module;
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;

            @NotNull
            public final Set<ClassDescriptor> invoke() {
                ReflectionTypes reflectionTypes = new ReflectionTypes(AbstractReflectionApiCallChecker.access$getModule$p(this.this$0));
                return SetsKt.setOf((Object[])new ClassDescriptor[]{reflectionTypes.getKProperty0(), reflectionTypes.getKProperty1(), reflectionTypes.getKProperty2()});
            }
            {
                this.this$0 = abstractReflectionApiCallChecker;
                super(0);
            }
        });
        this.ANY_MEMBER_NAMES = SetsKt.setOf((Object[])new String[]{"equals", "hashCode", "toString"});
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kPropertyClasses", "getKPropertyClasses()Ljava/util/Set;"))};
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$p(AbstractReflectionApiCallChecker $this) {
        return $this.module;
    }
}

