/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;

public class BringForwardJob
extends InlineDocumentJob {
    public BringForwardJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        Selection selection = this.getEditorController().getSelection();
        if (!(selection.getGroup() instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        for (FXOMObject item : osg.getSortedItems()) {
            FXOMObject nextSlibing = item.getNextSlibing();
            if (nextSlibing != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        assert (this.isExecutable());
        ArrayList<Job> result = new ArrayList<Job>();
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        List<FXOMObject> candidates = osg.getSortedItems();
        for (int i = candidates.size() - 1; i >= 0; --i) {
            FXOMObject beforeChild;
            ReIndexObjectJob subJob;
            FXOMObject candidate = candidates.get(i);
            FXOMObject nextSlibing = candidate.getNextSlibing();
            if (nextSlibing == null || !(subJob = new ReIndexObjectJob(candidate, beforeChild = nextSlibing.getNextSlibing(), this.getEditorController())).isExecutable()) continue;
            subJob.execute();
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        switch (this.getSubJobs().size()) {
            case 0: {
                result = "Unexecutable Bring Forward";
                break;
            }
            case 1: {
                result = this.getSubJobs().get(0).getDescription();
                break;
            }
            default: {
                result = this.makeMultipleSelectionDescription();
            }
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Bring Forward ");
        result.append(this.getSubJobs().size());
        result.append(" Objects");
        return result.toString();
    }
}

