/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.AbstractRelocater;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class PaneRelocater
extends AbstractRelocater<Pane> {
    private final double originalLayoutX;
    private final double originalLayoutY;
    private final PropertyName layoutXName = new PropertyName("layoutX");
    private final PropertyName layoutYName = new PropertyName("layoutY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public PaneRelocater(Node sceneGraphObject) {
        super(sceneGraphObject, Pane.class);
        this.originalLayoutX = sceneGraphObject.getLayoutX();
        this.originalLayoutY = sceneGraphObject.getLayoutY();
        this.propertyNames.add(this.layoutXName);
        this.propertyNames.add(this.layoutYName);
    }

    @Override
    public void moveToLayoutX(double newLayoutX, Bounds newLayoutBounds) {
        this.sceneGraphObject.setLayoutX((double)Math.round(newLayoutX));
    }

    @Override
    public void moveToLayoutY(double newLayoutY, Bounds newLayoutBounds) {
        this.sceneGraphObject.setLayoutY((double)Math.round(newLayoutY));
    }

    @Override
    public void revertToOriginalLocation() {
        this.sceneGraphObject.setLayoutX(this.originalLayoutX);
        this.sceneGraphObject.setLayoutY(this.originalLayoutY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.layoutXName) ? Double.valueOf(this.sceneGraphObject.getLayoutX()) : (propertyName.equals(this.layoutYName) ? Double.valueOf(this.sceneGraphObject.getLayoutY()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(this.sceneGraphObject.getLayoutX(), this.originalLayoutX)) {
            result.put(this.layoutXName, this.sceneGraphObject.getLayoutX());
        }
        if (!MathUtils.equals(this.sceneGraphObject.getLayoutY(), this.originalLayoutY)) {
            result.put(this.layoutYName, this.sceneGraphObject.getLayoutY());
        }
        return result;
    }
}

