/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.shape.Rectangle;

public class RectangleResizer
extends AbstractResizer<Rectangle> {
    private final double originalWidth;
    private final double originalHeight;
    private final PropertyName widthName = new PropertyName("width");
    private final PropertyName heightName = new PropertyName("height");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public RectangleResizer(Rectangle sceneGraphObject) {
        super(sceneGraphObject);
        this.originalWidth = sceneGraphObject.getWidth();
        this.originalHeight = sceneGraphObject.getHeight();
        this.propertyNames.add(this.widthName);
        this.propertyNames.add(this.heightName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double minX = ((Rectangle)this.sceneGraphObject).getX();
        double minY = ((Rectangle)this.sceneGraphObject).getY();
        return new BoundingBox(minX, minY, (double)Math.round(width), (double)Math.round(height));
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double width) {
        ((Rectangle)this.sceneGraphObject).setWidth((double)Math.round(width));
    }

    @Override
    public void changeHeight(double height) {
        ((Rectangle)this.sceneGraphObject).setHeight((double)Math.round(height));
    }

    @Override
    public void revertToOriginalSize() {
        ((Rectangle)this.sceneGraphObject).setWidth(this.originalWidth);
        ((Rectangle)this.sceneGraphObject).setHeight(this.originalHeight);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.widthName) ? Double.valueOf(((Rectangle)this.sceneGraphObject).getWidth()) : (propertyName.equals(this.heightName) ? Double.valueOf(((Rectangle)this.sceneGraphObject).getHeight()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Rectangle)this.sceneGraphObject).getWidth(), this.originalWidth)) {
            result.put(this.widthName, ((Rectangle)this.sceneGraphObject).getWidth());
        }
        if (!MathUtils.equals(((Rectangle)this.sceneGraphObject).getHeight(), this.originalHeight)) {
            result.put(this.heightName, ((Rectangle)this.sceneGraphObject).getHeight());
        }
        return result;
    }
}

