/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.ConfigureDeviceModel;
import com.android.tools.idea.avdmanager.ConfigureDeviceOptionsStep;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceUiAction
implements Action {
    @NotNull
    protected final DeviceProvider myProvider;
    @NotNull
    private final String myText;

    public DeviceUiAction(@NotNull DeviceProvider provider, @NotNull String text) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/avdmanager/DeviceUiAction", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/avdmanager/DeviceUiAction", "<init>"));
        }
        this.myProvider = provider;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceUiAction", "getText"));
        }
        return string;
    }

    @Override
    public Object getValue(String key) {
        return "Name".equals(key) ? this.myText : null;
    }

    @Override
    public void putValue(String key, Object value) {
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    static void showHardwareProfileWizard(ConfigureDeviceModel model) {
        ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ConfigureDeviceOptionsStep(model)).build();
        new StudioWizardDialogBuilder(wizard, "Hardware Profile Configuration").build().show();
    }

    public static interface DeviceProvider {
        @Nullable
        public Device getDevice();

        public void refreshDevices();

        public void setDevice(@Nullable Device var1);

        public void selectDefaultDevice();
    }
}

