/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.HelpAction;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.ContextController;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.controllers.FrameBufferController;
import com.android.tools.idea.editors.gfxtrace.controllers.GeometryController;
import com.android.tools.idea.editors.gfxtrace.controllers.MemoryController;
import com.android.tools.idea.editors.gfxtrace.controllers.ScrubberController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.controllers.TexturesController;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MainController
extends Controller {
    @NotNull
    private JBPanel myPanel;
    @NotNull
    private final RunnerLayoutUi myLayoutUi;
    @NotNull
    private final Content myAtomTab;
    @NotNull
    private final Content myStateTab;
    @NotNull
    private final Content myMemoryTab;
    @NotNull
    private final Content myGeoTab;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new MainController((GfxTraceEditor)editor).myPanel;
    }

    private MainController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "<init>"));
        }
        super(editor);
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        JBLabel experimentalBanner = new JBLabel(){
            {
                this.setText("The GPU Debugger is currently in beta.");
                this.setIcon(AllIcons.General.BalloonWarning);
                this.setBackground((Color)new JBColor(0xFFEE88, 10785106));
                this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
                this.setOpaque(true);
            }
        };
        experimentalBanner.setVisible(false);
        this.myEditor.addConnectionListener(server -> experimentalBanner.setVisible(!server.getFeatures().isStable()));
        DefaultActionGroup globalGroup = new DefaultActionGroup();
        globalGroup.add((AnAction)new HelpAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)globalGroup, true);
        toolbar.setLayoutPolicy(0);
        JBPanel contextAndActions = new JBPanel((LayoutManager)new BorderLayout());
        contextAndActions.add((Component)ContextController.createUI(editor), (Object)"Center");
        contextAndActions.add((Component)toolbar.getComponent(), (Object)"East");
        JBPanel top = new JBPanel((LayoutManager)new GridLayout(2, 1));
        top.add((Component)experimentalBanner);
        top.add((Component)contextAndActions);
        this.myPanel.add((Component)top, (Object)"North");
        ThreeComponentsSplitter splitter = new ThreeComponentsSplitter(true){

            public void setBounds(int x, int y, int width, int height) {
                if (width > 0 && height > 0) {
                    super.setBounds(x, y, width, height);
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)splitter);
        this.myPanel.add((Component)splitter, (Object)"Center");
        splitter.setDividerWidth(5);
        splitter.setFirstComponent(ScrubberController.createUI(editor));
        splitter.setFirstSize(150);
        this.myLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)editor.getProject()).create("gfx-trace-runnerId", editor.getName(), editor.getSessionName(), (Disposable)this);
        this.myAtomTab = MainController.addTab(this.myLayoutUi, AtomController.createUI(editor), "GPU Commands", PlaceInGrid.left);
        MainController.addTab(this.myLayoutUi, FrameBufferController.createUI(editor), "Framebuffer", PlaceInGrid.center);
        MainController.addTab(this.myLayoutUi, TexturesController.createUI(editor), "Textures", PlaceInGrid.center);
        this.myGeoTab = MainController.addTab(this.myLayoutUi, GeometryController.createUI(editor), "Geometry", PlaceInGrid.center);
        this.myStateTab = MainController.addTab(this.myLayoutUi, StateController.createUI(editor), "GPU State", PlaceInGrid.center);
        this.myMemoryTab = MainController.addTab(this.myLayoutUi, MemoryController.createUI(editor), "Memory", PlaceInGrid.center);
        splitter.setLastComponent(this.myLayoutUi.getComponent());
        MainController.setInitialSizeRecursive((Component)splitter);
    }

    private static Content addTab(@NotNull RunnerLayoutUi layoutUi, @NotNull JComponent component, @NotNull String name, @NotNull PlaceInGrid defaultPlace) {
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "addTab"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "addTab"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "addTab"));
        }
        if (defaultPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPlace", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "addTab"));
        }
        Content content = layoutUi.createContent(name + "-contentId", component, name, null, null);
        content.setCloseable(false);
        layoutUi.addContent(content, -1, defaultPlace, false);
        return content;
    }

    private static void setInitialSizeRecursive(Component component) {
        if (component instanceof ThreeComponentsSplitter) {
            component.setSize(1000, 500);
        }
        if (component instanceof Container) {
            for (Component comp : ((Container)component).getComponents()) {
                MainController.setInitialSizeRecursive(comp);
            }
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        if (event.findTypedMemoryPath() != null || event.findMemoryPath() != null) {
            this.select(this.myMemoryTab);
        } else if (event.findStatePath() != null) {
            this.select(this.myStateTab);
        } else if (event.findAtomPath() != null) {
            this.select(this.myAtomTab);
        }
    }

    private void select(Content content) {
        MainController.restoreIfMinimized(this.myLayoutUi, content);
        this.myLayoutUi.selectAndFocus(content, true, true, true);
    }

    public static void restoreIfMinimized(RunnerLayoutUi layoutUi, Content content) {
        RunnerContentUi ui;
        JComponent component = layoutUi.getComponent();
        if (component instanceof DataProvider && (ui = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)component)) != null) {
            ui.restoreContent((String)content.getUserData(ViewImpl.ID));
        }
    }

    @Override
    public void clear() {
        this.myPanel.removeAll();
    }
}

